/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.api;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.netxms.client.AgentFileData;
import org.netxms.client.NXCSession;
import org.netxms.client.ProgressListener;
import org.netxms.client.objecttools.InputField;
import org.netxms.client.objecttools.InputFieldType;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.filemanager.views.AgentFileViewer;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objects.ObjectContext;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.api.ObjectToolHandler;
import org.netxms.ui.eclipse.objecttools.api.ObjectToolsCache;
import org.netxms.ui.eclipse.objecttools.dialogs.ObjectToolInputDialog;
import org.netxms.ui.eclipse.objecttools.views.AgentActionResults;
import org.netxms.ui.eclipse.objecttools.views.BrowserView;
import org.netxms.ui.eclipse.objecttools.views.LocalCommandResults;
import org.netxms.ui.eclipse.objecttools.views.ServerCommandResults;
import org.netxms.ui.eclipse.objecttools.views.ServerScriptResults;
import org.netxms.ui.eclipse.objecttools.views.TableToolResults;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public final class ObjectToolExecutor {
    private ObjectToolExecutor() {
    }

    public static boolean isToolAllowed(ObjectTool tool, Set<ObjectContext> nodes) {
        if (tool.getType() != 0) {
            return true;
        }
        ObjectToolHandler handler = ObjectToolsCache.findHandler(tool.getData());
        if (handler != null) {
            for (ObjectContext n : nodes) {
                if (handler.canExecuteOnNode(n.object, tool)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isToolApplicable(ObjectTool tool, Set<ObjectContext> nodes) {
        for (ObjectContext n : nodes) {
            if (tool.isApplicableForNode(n.object)) continue;
            return false;
        }
        return true;
    }

    public static void execute(final Set<ObjectContext> nodes, final ObjectTool tool) {
        HashMap<String, String> inputValues;
        final InputField[] fields = tool.getInputFields();
        if (fields.length > 0) {
            Arrays.sort(fields, new Comparator<InputField>(){

                @Override
                public int compare(InputField f1, InputField f2) {
                    return f1.getSequence() - f2.getSequence();
                }
            });
            inputValues = ObjectToolExecutor.readInputFields(fields);
            if (inputValues == null) {
                return;
            }
        } else {
            inputValues = new HashMap(0);
        }
        if ((tool.getFlags() & 1) != 0) {
            String message = tool.getConfirmationText();
            if (nodes.size() == 1) {
                ObjectContext node = nodes.iterator().next();
                message = node.substituteMacros(message, new HashMap(0));
            } else {
                message = new ObjectContext(null, null).substituteMacros(message, new HashMap(0));
            }
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            Messages.get();
            if (!MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_ConfirmExec, (String)message)) {
                return;
            }
        }
        boolean validationNeeded = false;
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getOptions().validatePassword) {
                validationNeeded = true;
                break;
            }
            ++i;
        }
        if (validationNeeded) {
            final NXCSession session = ConsoleSharedData.getSession();
            Messages.get();
            new ConsoleJob(Messages.ObjectToolExecutor_JobName, null, "org.netxms.ui.eclipse.objecttools", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    int i = 0;
                    while (i < fields.length) {
                        boolean valid;
                        if (fields[i].getType() == InputFieldType.PASSWORD && fields[i].getOptions().validatePassword && !(valid = session.validateUserPassword((String)inputValues.get(fields[i].getName())))) {
                            final String fieldName = fields[i].getDisplayName();
                            this.getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Messages.get();
                                    Messages.get();
                                    MessageDialogHelper.openError(null, (String)Messages.ObjectToolExecutor_ErrorTitle, (String)String.format(Messages.ObjectToolExecutor_ErrorText, fieldName));
                                }
                            });
                            return;
                        }
                        ++i;
                    }
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            for (ObjectContext n : nodes) {
                                ObjectToolExecutor.executeOnNode(n, tool, inputValues);
                            }
                        }
                    });
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.ObjectToolExecutor_PasswordValidationFailed;
                }
            }.start();
        } else {
            for (ObjectContext n : nodes) {
                ObjectToolExecutor.executeOnNode(n, tool, inputValues);
            }
        }
    }

    private static Map<String, String> readInputFields(InputField[] fields) {
        ObjectToolInputDialog dlg = new ObjectToolInputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), fields);
        if (dlg.open() != 0) {
            return null;
        }
        return dlg.getValues();
    }

    private static void executeOnNode(ObjectContext node, ObjectTool tool, Map<String, String> inputValues) {
        switch (tool.getType()) {
            case 1: {
                ObjectToolExecutor.executeAgentAction(node, tool, inputValues);
                break;
            }
            case 7: {
                ObjectToolExecutor.executeFileDownload(node, tool, inputValues);
                break;
            }
            case 0: {
                ObjectToolExecutor.executeInternalTool(node, tool);
                break;
            }
            case 5: {
                ObjectToolExecutor.executeLocalCommand(node, tool, inputValues);
                break;
            }
            case 6: {
                ObjectToolExecutor.executeServerCommand(node, tool, inputValues);
                break;
            }
            case 8: {
                ObjectToolExecutor.executeServerScript(node, tool, inputValues);
                break;
            }
            case 2: 
            case 3: {
                ObjectToolExecutor.executeTableTool(node, tool);
                break;
            }
            case 4: {
                ObjectToolExecutor.openURL(node, tool, inputValues);
            }
        }
    }

    private static void executeTableTool(ObjectContext node, ObjectTool tool) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page = window.getActivePage();
            TableToolResults view = (TableToolResults)page.showView("org.netxms.ui.eclipse.objecttools.views.TableToolResults", String.valueOf(Long.toString(tool.getId())) + "&" + Long.toString(node.object.getObjectId()), 1);
            view.refreshTable();
        }
        catch (PartInitException e) {
            Shell shell = window.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)String.format(Messages.ObjectToolsDynamicMenu_ErrorOpeningView, e.getLocalizedMessage()));
        }
    }

    private static String[] splitCommandLine(String input) {
        char[] in = input.toCharArray();
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int state = 0;
        char[] cArray = in;
        int n = in.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (state) {
                case 0: {
                    if (Character.isSpaceChar(c)) {
                        args.add(sb.toString());
                        sb = new StringBuilder();
                        state = 3;
                        break;
                    }
                    if (c == '\"') {
                        state = 1;
                        break;
                    }
                    if (c == '\'') {
                        state = 2;
                        break;
                    }
                    sb.append(c);
                    break;
                }
                case 1: {
                    if (c == '\"') {
                        state = 0;
                        break;
                    }
                    sb.append(c);
                    break;
                }
                case 2: {
                    if (c == '\'') {
                        state = 0;
                        break;
                    }
                    sb.append(c);
                    break;
                }
                case 3: {
                    if (Character.isSpaceChar(c)) break;
                    if (c == '\"') {
                        state = 1;
                        break;
                    }
                    if (c == '\'') {
                        state = 2;
                        break;
                    }
                    sb.append(c);
                    state = 0;
                }
            }
            ++n2;
        }
        if (state != 3) {
            args.add(sb.toString());
        }
        return args.toArray(new String[args.size()]);
    }

    private static void executeAgentAction(final ObjectContext node, ObjectTool tool, Map<String, String> inputValues) {
        final NXCSession session = ConsoleSharedData.getSession();
        String[] parts = ObjectToolExecutor.splitCommandLine(node.substituteMacros(tool.getData(), inputValues));
        final String action = parts[0];
        final String[] args = Arrays.copyOfRange(parts, 1, parts.length);
        if ((tool.getFlags() & 2) == 0) {
            Messages.get();
            new ConsoleJob(String.format(Messages.ObjectToolsDynamicMenu_ExecuteOnNode, node.object.getObjectName()), null, "org.netxms.ui.eclipse.objecttools", null){

                protected String getErrorMessage() {
                    Messages.get();
                    return String.format(Messages.ObjectToolsDynamicMenu_CannotExecuteOnNode, node.object.getObjectName());
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    session.executeAction(node.object.getObjectId(), action, args);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Messages.get();
                            Messages.get();
                            MessageDialogHelper.openInformation(null, (String)Messages.ObjectToolsDynamicMenu_ToolExecution, (String)String.format(Messages.ObjectToolsDynamicMenu_ExecSuccess, action, node.object.getObjectName()));
                        }
                    });
                }
            }.start();
        } else {
            String secondaryId = String.valueOf(Long.toString(node.object.getObjectId())) + "&" + Long.toString(tool.getId());
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            try {
                AgentActionResults view = (AgentActionResults)window.getActivePage().showView("org.netxms.ui.eclipse.objecttools.views.AgentActionResults", secondaryId, 1);
                view.executeAction(action, args);
            }
            catch (Exception e) {
                Shell shell = window.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)String.format(Messages.ObjectToolsDynamicMenu_ErrorOpeningView, e.getLocalizedMessage()));
            }
        }
    }

    private static void executeServerCommand(final ObjectContext node, final ObjectTool tool, final Map<String, String> inputValues) {
        final NXCSession session = ConsoleSharedData.getSession();
        if ((tool.getFlags() & 2) == 0) {
            Messages.get();
            new ConsoleJob(Messages.ObjectToolsDynamicMenu_ExecuteServerCmd, null, "org.netxms.ui.eclipse.objecttools", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    session.executeServerCommand(node.object.getObjectId(), tool.getData(), inputValues);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Messages.get();
                            Messages.get();
                            MessageDialogHelper.openInformation(null, (String)Messages.ObjectToolsDynamicMenu_Information, (String)Messages.ObjectToolsDynamicMenu_ServerCommandExecuted);
                        }
                    });
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.ObjectToolsDynamicMenu_ServerCmdExecError;
                }
            }.start();
        } else {
            String secondaryId = String.valueOf(Long.toString(node.object.getObjectId())) + "&" + Long.toString(tool.getId());
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            try {
                ServerCommandResults view = (ServerCommandResults)window.getActivePage().showView("org.netxms.ui.eclipse.objecttools.views.ServerCommandResults", secondaryId, 1);
                view.executeCommand(tool.getData(), inputValues);
            }
            catch (Exception e) {
                Shell shell = window.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)String.format(Messages.ObjectToolsDynamicMenu_ErrorOpeningView, e.getLocalizedMessage()));
            }
        }
    }

    private static void executeServerScript(final ObjectContext node, final ObjectTool tool, final Map<String, String> inputValues) {
        final NXCSession session = ConsoleSharedData.getSession();
        if ((tool.getFlags() & 2) == 0) {
            new ConsoleJob("Execute server script", null, "org.netxms.ui.eclipse.objecttools", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    session.executeLibraryScript(node.object.getObjectId(), tool.getData(), inputValues, null);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Messages.get();
                            Messages.get();
                            MessageDialogHelper.openInformation(null, (String)Messages.ObjectToolsDynamicMenu_Information, (String)Messages.ObjectToolsDynamicMenu_ServerScriptExecuted);
                        }
                    });
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.ObjectToolsDynamicMenu_ServerScriptExecError;
                }
            }.start();
        } else {
            String secondaryId = String.valueOf(Long.toString(node.object.getObjectId())) + "&" + Long.toString(tool.getId());
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            try {
                ServerScriptResults view = (ServerScriptResults)window.getActivePage().showView("org.netxms.ui.eclipse.objecttools.views.ServerScriptResults", secondaryId, 1);
                view.executeScript(tool.getData(), inputValues);
            }
            catch (Exception e) {
                Shell shell = window.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)String.format(Messages.ObjectToolsDynamicMenu_ErrorOpeningView, e.getLocalizedMessage()));
            }
        }
    }

    private static void executeLocalCommand(ObjectContext node, ObjectTool tool, Map<String, String> inputValues) {
        block7: {
            String command = node.substituteMacros(tool.getData(), inputValues);
            if ((tool.getFlags() & 2) == 0) {
                String os = Platform.getOS();
                try {
                    if (os.equals("win32")) {
                        command = "CMD.EXE /C START \"NetXMS\" " + command;
                        Runtime.getRuntime().exec(command);
                        break block7;
                    }
                    Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                String secondaryId = String.valueOf(Long.toString(node.object.getObjectId())) + "&" + Long.toString(tool.getId());
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                try {
                    LocalCommandResults view = (LocalCommandResults)window.getActivePage().showView("org.netxms.ui.eclipse.objecttools.views.LocalCommandResults", secondaryId, 1);
                    view.runCommand(command);
                }
                catch (Exception e) {
                    Shell shell = window.getShell();
                    Messages.get();
                    Messages.get();
                    MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)String.format(Messages.ObjectToolsDynamicMenu_ErrorOpeningView, e.getLocalizedMessage()));
                }
            }
        }
    }

    private static void executeFileDownload(final ObjectContext node, ObjectTool tool, Map<String, String> inputValues) {
        final NXCSession session = ConsoleSharedData.getSession();
        String[] parameters = tool.getData().split("\u007f");
        final String fileName = node.substituteMacros(parameters[0], inputValues);
        final int maxFileSize = Integer.parseInt(parameters[1]);
        final boolean follow = parameters[2].equals("true");
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.ObjectToolsDynamicMenu_DownloadFromAgent, null, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.ObjectToolsDynamicMenu_DownloadError, fileName, node.object.getObjectName());
            }

            protected void runInternal(final IProgressMonitor monitor) throws Exception {
                final AgentFileData file = session.downloadFileFromAgent(node.object.getObjectId(), fileName, (long)maxFileSize, follow, new ProgressListener(){

                    public void setTotalWorkAmount(long workTotal) {
                        monitor.beginTask("Tail file " + fileName, (int)workTotal);
                    }

                    public void markProgress(long workDone) {
                        monitor.worked((int)workDone);
                    }
                });
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String secondaryId = String.valueOf(Long.toString(node.object.getObjectId())) + "&" + URLEncoder.encode(fileName, "UTF-8");
                            AgentFileViewer.createView((String)secondaryId, (long)node.object.getObjectId(), (AgentFileData)file, (boolean)follow);
                        }
                        catch (Exception e) {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            Shell shell = window.getShell();
                            Messages.get();
                            Messages.get();
                            MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)String.format(Messages.ObjectToolsDynamicMenu_ErrorOpeningView, e.getLocalizedMessage()));
                        }
                    }
                });
            }
        };
        job.start();
    }

    private static void executeInternalTool(ObjectContext node, ObjectTool tool) {
        ObjectToolHandler handler = ObjectToolsCache.findHandler(tool.getData());
        if (handler != null) {
            handler.execute(node.object, tool);
        } else {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)Messages.ObjectToolsDynamicMenu_HandlerNotDefined);
        }
    }

    private static void openURL(ObjectContext node, ObjectTool tool, Map<String, String> inputValues) {
        String url = node.substituteMacros(tool.getData(), inputValues);
        String sid = String.valueOf(Long.toString(node.object.getObjectId())) + "&" + Long.toString(tool.getId());
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            BrowserView view = (BrowserView)window.getActivePage().showView("org.netxms.ui.eclipse.objecttools.views.BrowserView", sid, 1);
            view.openUrl(url);
        }
        catch (PartInitException e) {
            Shell shell = window.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)(String.valueOf(Messages.ObjectToolsDynamicMenu_CannotOpenWebBrowser) + e.getLocalizedMessage()));
        }
    }
}

