/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.zip.CRC32;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.netxms.base.NXCPDataInputStream;
import org.netxms.base.NXCPException;
import org.netxms.base.NXCPMessage;

public final class EncryptionContext {
    private static final String[] CIPHERS;
    private static int[] KEY_LENGTHS;
    private static final String CIPHER_MODE = "/CBC/PKCS5Padding";
    private static final byte[] TEST_BYTES;
    private static final boolean[] cipherTests;
    private int cipher;
    private int keyLength;
    private Cipher encryptor;
    private Cipher decryptor;
    private SecretKey key;
    private IvParameterSpec iv;

    static {
        String[] stringArray = new String[6];
        stringArray[0] = "AES";
        stringArray[1] = "Blowfish";
        stringArray[4] = "AES";
        stringArray[5] = "Blowfish";
        CIPHERS = stringArray;
        int[] nArray = new int[6];
        nArray[0] = 256;
        nArray[1] = 256;
        nArray[4] = 128;
        nArray[5] = 128;
        KEY_LENGTHS = nArray;
        TEST_BYTES = "Test String".getBytes();
        cipherTests = new boolean[CIPHERS.length];
        int i = 0;
        while (i < CIPHERS.length) {
            EncryptionContext.cipherTests[i] = EncryptionContext.testCipher(i);
            ++i;
        }
    }

    public static String getCipherName(int cipher) {
        try {
            return String.valueOf(CIPHERS[cipher]) + "-" + Integer.toString(KEY_LENGTHS[cipher]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private static void safeWriteBytes(ByteArrayOutputStream bs, byte[] bytes) throws IOException {
        if (bytes != null) {
            bs.write(bytes);
        }
    }

    public static boolean testCipher(int cipherId) {
        if (CIPHERS[cipherId] == null) {
            return false;
        }
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(CIPHERS[cipherId]);
            keyGen.init(KEY_LENGTHS[cipherId]);
            SecretKey key = keyGen.generateKey();
            Cipher cipher = Cipher.getInstance(String.valueOf(CIPHERS[cipherId]) + CIPHER_MODE);
            int blockSize = cipher.getBlockSize();
            byte[] ivBytes = new byte[blockSize > 0 ? blockSize : 16];
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.nextBytes(ivBytes);
            IvParameterSpec iv = new IvParameterSpec(ivBytes);
            ByteArrayOutputStream bs = new ByteArrayOutputStream(128);
            cipher.init(1, (Key)key, iv);
            EncryptionContext.safeWriteBytes(bs, cipher.update(TEST_BYTES));
            EncryptionContext.safeWriteBytes(bs, cipher.doFinal());
            byte[] encryptedBytes = bs.toByteArray();
            bs.reset();
            cipher = Cipher.getInstance(String.valueOf(CIPHERS[cipherId]) + CIPHER_MODE);
            cipher.init(2, (Key)key, iv);
            EncryptionContext.safeWriteBytes(bs, cipher.update(encryptedBytes));
            EncryptionContext.safeWriteBytes(bs, cipher.doFinal());
            return Arrays.equals(TEST_BYTES, bs.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static EncryptionContext createInstance(NXCPMessage request) throws NXCPException {
        int serverCiphers = request.getFieldAsInt32(122L);
        int selectedCipher = -1;
        int i = 0;
        while (i < CIPHERS.length) {
            if (CIPHERS[i] != null && cipherTests[i] && (serverCiphers & 1 << i) != 0) {
                try {
                    Cipher.getInstance(String.valueOf(CIPHERS[i]) + CIPHER_MODE);
                    if (Cipher.getMaxAllowedKeyLength(String.valueOf(CIPHERS[i]) + CIPHER_MODE) >= KEY_LENGTHS[i]) {
                        selectedCipher = i;
                        break;
                    }
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        if (selectedCipher != -1) {
            try {
                return new EncryptionContext(selectedCipher);
            }
            catch (Exception e) {
                throw new NXCPException(3, (Throwable)e);
            }
        }
        throw new NXCPException(3);
    }

    protected EncryptionContext(int cipher) throws GeneralSecurityException {
        this.cipher = cipher;
        this.keyLength = KEY_LENGTHS[cipher];
        KeyGenerator keyGen = KeyGenerator.getInstance(CIPHERS[cipher]);
        keyGen.init(KEY_LENGTHS[cipher]);
        this.key = keyGen.generateKey();
        this.encryptor = Cipher.getInstance(String.valueOf(CIPHERS[cipher]) + CIPHER_MODE);
        this.decryptor = Cipher.getInstance(String.valueOf(CIPHERS[cipher]) + CIPHER_MODE);
        int blockSize = this.encryptor.getBlockSize();
        byte[] ivBytes = new byte[blockSize > 0 ? blockSize : 16];
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.nextBytes(ivBytes);
        this.iv = new IvParameterSpec(ivBytes);
    }

    public byte[] getEncryptedSessionKey(NXCPMessage msg) throws GeneralSecurityException {
        byte[] pkeyBytes = msg.getFieldAsBinary(154L);
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(pkeyBytes));
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
        cipher.init(1, publicKey);
        return cipher.doFinal(this.key.getEncoded());
    }

    public byte[] getEncryptedIv(NXCPMessage msg) throws GeneralSecurityException {
        byte[] pkeyBytes = msg.getFieldAsBinary(154L);
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(pkeyBytes));
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
        cipher.init(1, publicKey);
        return cipher.doFinal(this.iv.getIV());
    }

    private byte[] encryptPayloadHeader(byte[] msgBytes) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(byteStream);
        CRC32 crc32 = new CRC32();
        crc32.update(msgBytes);
        outputStream.writeInt((int)crc32.getValue());
        outputStream.writeInt(0);
        return this.encryptor.update(byteStream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encryptMessage(NXCPMessage msg, boolean allowCompression) throws IOException, GeneralSecurityException {
        byte[] msgBytes = msg.createNXCPMessage(allowCompression);
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(byteStream);
        outputStream.writeShort(131);
        outputStream.writeByte(0);
        outputStream.writeByte(0);
        outputStream.writeInt(0);
        Cipher cipher = this.encryptor;
        synchronized (cipher) {
            this.encryptor.init(1, (Key)this.key, this.iv);
            byte[] ph = this.encryptPayloadHeader(msgBytes);
            if (ph != null) {
                outputStream.write(ph);
            }
            outputStream.write(this.encryptor.update(msgBytes));
            outputStream.write(this.encryptor.doFinal());
        }
        int padding = 8 - byteStream.size() % 8 & 7;
        int i = 0;
        while (i < padding) {
            outputStream.writeByte(0);
            ++i;
        }
        byte[] encryptedMessage = byteStream.toByteArray();
        encryptedMessage[2] = (byte)padding;
        encryptedMessage[4] = (byte)(encryptedMessage.length >> 24);
        encryptedMessage[5] = (byte)(encryptedMessage.length >> 16 & 0xFF);
        encryptedMessage[6] = (byte)(encryptedMessage.length >> 8 & 0xFF);
        encryptedMessage[7] = (byte)(encryptedMessage.length & 0xFF);
        return encryptedMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decryptMessage(NXCPDataInputStream inputStream, int length) throws GeneralSecurityException, IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int bytes = length;
        Cipher cipher = this.decryptor;
        synchronized (cipher) {
            this.decryptor.init(2, (Key)this.key, this.iv);
            while (bytes > 0) {
                int bytesRead = inputStream.read(buffer, 0, Math.min(buffer.length, bytes));
                byteStream.write(this.decryptor.update(buffer, 0, bytesRead));
                bytes -= bytesRead;
            }
            byteStream.write(this.decryptor.doFinal());
        }
        return byteStream.toByteArray();
    }

    public int getCipher() {
        return this.cipher;
    }

    public int getKeyLength() {
        return this.keyLength / 8;
    }

    public int getIvLength() {
        return this.iv.getIV().length;
    }
}

