/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum NodeType {
    UNKNOWN(0),
    PHYSICAL(1),
    VIRTUAL(2),
    CONTROLLER(3);

    private int value;
    private static Map<Integer, NodeType> lookupTable;

    static {
        lookupTable = new HashMap<Integer, NodeType>();
        NodeType[] nodeTypeArray = NodeType.values();
        int n = nodeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeType element = nodeTypeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private NodeType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static NodeType getByValue(int value) {
        NodeType element = lookupTable.get(value);
        if (element == null) {
            Logger.warning(NodeType.class.getName(), "Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }
}

