/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.tools;

import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.tools.TextFieldValidator;

public class NumericTextFieldValidator
implements TextFieldValidator {
    private long min;
    private long max;
    private String range;

    public NumericTextFieldValidator(long min, long max) {
        this.min = min;
        this.max = max;
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Long.toString(min)));
        Messages.get();
        this.range = stringBuilder.append(Messages.NumericTextFieldValidator_RangeSeparator).append(Long.toString(max)).toString();
    }

    @Override
    public boolean validate(String text) {
        try {
            long value = Long.parseLong(text);
            return value >= this.min && value <= this.max;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public String getErrorMessage(String text, String label) {
        Messages.get();
        return String.format(Messages.NumericTextFieldValidator_ErrorMessage, this.range, label);
    }
}

