/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.widgets.helpers;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.events.Alarm;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class AlarmComparator
extends ViewerComparator {
    public int compare(Viewer viewer, Object e1, Object e2) {
        int rc;
        TableColumn sortColumn = ((TableViewer)viewer).getTable().getSortColumn();
        if (sortColumn == null) {
            return 0;
        }
        switch ((Integer)sortColumn.getData("ID")) {
            case 0: {
                rc = ((Alarm)e1).getCurrentSeverity().compareTo((Enum)((Alarm)e2).getCurrentSeverity());
                break;
            }
            case 1: {
                rc = Integer.signum(((Alarm)e1).getState() - ((Alarm)e2).getState());
                break;
            }
            case 2: {
                String string;
                String name1;
                String string2;
                AbstractObject obj1 = ConsoleSharedData.getSession().findObjectById(((Alarm)e1).getSourceObjectId());
                AbstractObject obj2 = ConsoleSharedData.getSession().findObjectById(((Alarm)e2).getSourceObjectId());
                if (obj1 != null) {
                    string2 = obj1.getObjectName();
                } else {
                    Messages.get();
                    string2 = name1 = Messages.AlarmComparator_Unknown;
                }
                if (obj2 != null) {
                    string = obj2.getObjectName();
                } else {
                    Messages.get();
                    string = Messages.AlarmComparator_Unknown;
                }
                String name2 = string;
                rc = name1.compareToIgnoreCase(name2);
                break;
            }
            case 4: {
                rc = ((Alarm)e1).getMessage().compareToIgnoreCase(((Alarm)e2).getMessage());
                break;
            }
            case 5: {
                rc = Integer.signum(((Alarm)e1).getRepeatCount() - ((Alarm)e2).getRepeatCount());
                break;
            }
            case 9: {
                rc = ((Alarm)e1).getCreationTime().compareTo(((Alarm)e2).getCreationTime());
                break;
            }
            case 10: {
                rc = ((Alarm)e1).getLastChangeTime().compareTo(((Alarm)e2).getLastChangeTime());
                break;
            }
            default: {
                rc = 0;
            }
        }
        int dir = ((TableViewer)viewer).getTable().getSortDirection();
        return dir == 128 ? rc : -rc;
    }
}

