/*
 * Decompiled with CFR 0.152.
 */
package name.pachler.nio.file.impl;

import name.pachler.nio.file.impl.NativeLibLoader;

public class Windows {
    public static final int GENERIC_READ = Integer.MIN_VALUE;
    public static final int GENERIC_WRITE = 0x40000000;
    public static final int GENERIC_EXECUTE = 0x20000000;
    public static final int GENERIC_ALL = 0x10000000;
    public static final int FILE_LIST_DIRECTORY = 1;
    public static final int FILE_READ_DATA = 1;
    public static final int FILE_ADD_FILE = 2;
    public static final int FILE_WRITE_DATA = 2;
    public static final int FILE_ADD_SUBDIRECTORY = 4;
    public static final int FILE_APPEND_DATA = 4;
    public static final int FILE_CREATE_PIPE_INSTANCE = 4;
    public static final int FILE_READ_EA = 8;
    public static final int FILE_READ_PROPERTIES = 8;
    public static final int FILE_WRITE_EA = 16;
    public static final int FILE_WRITE_PROPERTIES = 16;
    public static final int FILE_EXECUTE = 32;
    public static final int FILE_TRAVERSE = 32;
    public static final int FILE_DELETE_CHILD = 64;
    public static final int FILE_READ_ATTRIBUTES = 128;
    public static final int FILE_WRITE_ATTRIBUTES = 256;
    public static final int FILE_SHARE_READ = 1;
    public static final int FILE_SHARE_WRITE = 2;
    public static final int FILE_SHARE_DELETE = 4;
    public static final int CREATE_NEW = 1;
    public static final int CREATE_ALWAYS = 2;
    public static final int OPEN_EXISTING = 3;
    public static final int OPEN_ALWAYS = 4;
    public static final int TRUNCATE_EXISTING = 5;
    public static final int FILE_ATTRIBUTE_READONLY = 1;
    public static final int FILE_ATTRIBUTE_TEMPORARY = 256;
    public static final int FILE_ATTRIBUTE_SYSTEM = 4;
    public static final int FILE_ATTRIBUTE_OFFLINE = 4096;
    public static final int FILE_ATTRIBUTE_NORMAL = 128;
    public static final int FILE_ATTRIBUTE_HIDDEN = 2;
    public static final int FILE_ATTRIBUTE_ENCRYPTED = 16384;
    public static final int FILE_ATTRIBUTE_ARCHIVE = 32;
    public static final int FILE_FLAG_BACKUP_SEMANTICS = 0x2000000;
    public static final int FILE_FLAG_DELETE_ON_CLOSE = 0x4000000;
    public static final int FILE_FLAG_NO_BUFFERING = 0x20000000;
    public static final int FILE_FLAG_OPEN_NO_RECALL = 0x100000;
    public static final int FILE_FLAG_OPEN_REPARSE_POINT = 0x200000;
    public static final int FILE_FLAG_OVERLAPPED = 0x40000000;
    public static final int FILE_FLAG_POSIX_SEMANTICS = 0x100000;
    public static final int FILE_FLAG_RANDOM_ACCESS = 0x10000000;
    public static final int FILE_FLAG_SEQUENTIAL_SCAN = 0x8000000;
    public static final int FILE_FLAG_WRITE_THROUGH = Integer.MIN_VALUE;
    public static final long INVALID_HANDLE_VALUE;
    public static final int ERROR_ALREADY_EXISTS = 183;
    public static final int ERROR_FILE_NOT_FOUND = 2;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int ERROR_FILE_EXISTS = 80;
    public static final int ERROR_INVALID_FUNCTION = 1;
    public static final int ERROR_OPERATION_ABORTED = 995;
    public static final int ERROR_IO_INCOMPLETE = 996;
    public static final int ERROR_IO_PENDING = 997;
    static final int FILE_NOTIFY_CHANGE_FILE_NAME = 1;
    static final int FILE_NOTIFY_CHANGE_DIR_NAME = 2;
    static final int FILE_NOTIFY_CHANGE_ATTRIBUTES = 4;
    static final int FILE_NOTIFY_CHANGE_SIZE = 8;
    static final int FILE_NOTIFY_CHANGE_LAST_WRITE = 16;
    static final int FILE_NOTIFY_CHANGE_LAST_ACCESS = 32;
    static final int FILE_NOTIFY_CHANGE_CREATION = 64;
    static final int FILE_NOTIFY_CHANGE_SECURITY = 256;
    static final int FILE_ACTION_ADDED = 1;
    static final int FILE_ACTION_REMOVED = 2;
    static final int FILE_ACTION_MODIFIED = 3;
    static final int FILE_ACTION_RENAMED_OLD_NAME = 4;
    static final int FILE_ACTION_RENAMED_NEW_NAME = 5;
    static final int FILE_ACTION_ADDED_STREAM = 6;
    static final int FILE_ACTION_REMOVED_STREAM = 7;
    static final int FILE_ACTION_MODIFIED_STREAM = 8;
    static final int FILE_ACTION_REMOVED_BY_DELETE = 9;
    static final int FILE_ACTION_ID_NOT_TUNNELLED = 10;
    static final int FILE_ACTION_TUNNELLED_ID_COLLISION = 11;
    static final int WAIT_OBJECT_0 = 0;
    static final int WAIT_ABANDONED_0 = 128;
    static final int WAIT_TIMEOUT = 258;
    static final int WAIT_FAILED = -1;
    static final int MAXIMUM_WAIT_OBJECTS = 64;
    static final int INFINITE = -1;

    private static native long getINVALID_HANDLE_VALUE();

    static native String GetLongPathName(String var0);

    static native String GetShortPathName(String var0);

    static native long CreateFile(String var0, int var1, int var2, SECURITY_ATTRIBUTES var3, int var4, int var5, long var6);

    static native long CreateEvent(SECURITY_ATTRIBUTES var0, boolean var1, boolean var2, String var3);

    static native boolean SetEvent(long var0);

    static native boolean ResetEvent(long var0);

    static native boolean ReadDirectoryChanges(long var0, ByteBuffer var2, boolean var3, int var4, int[] var5, OVERLAPPED var6, Runnable var7);

    static native int WaitForMultipleObjects(long[] var0, boolean var1, int var2);

    static native int GetLastError();

    static native String GetLastError_toString(int var0);

    static native boolean CloseHandle(long var0);

    static native boolean GetOverlappedResult(long var0, OVERLAPPED var2, int[] var3, boolean var4);

    static native boolean CancelIo(long var0);

    static {
        NativeLibLoader.loadLibrary("jpathwatch-native");
        INVALID_HANDLE_VALUE = Windows.getINVALID_HANDLE_VALUE();
    }

    static class SECURITY_ATTRIBUTES {
        SECURITY_DESCRIPTOR securityDescriptor;
        boolean ineritHandle;

        SECURITY_ATTRIBUTES() {
        }
    }

    static class SECURITY_DESCRIPTOR {
        SECURITY_DESCRIPTOR() {
        }
    }

    static class ByteBuffer {
        private long bufferAddress;
        private int bufferSize;

        private static native long allocate(int var0);

        private static native void deallocate(long var0);

        private static native void initNative();

        ByteBuffer(int bufferSize) {
            if (bufferSize < 0) {
                throw new IllegalArgumentException("bufferSize may not be less than zero");
            }
            this.bufferAddress = ByteBuffer.allocate(bufferSize);
            this.bufferSize = bufferSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                ByteBuffer.deallocate(this.bufferAddress);
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                super.finalize();
                throw throwable;
            }
            super.finalize();
        }

        static {
            ByteBuffer.initNative();
        }
    }

    static class OVERLAPPED {
        private long peer = OVERLAPPED.allocatePeer();
        private long offset;
        private long eventHandle;

        private static native long allocatePeer();

        private static native void deallocatePeer(long var0);

        private static native void setEventOnPeer(long var0, long var2);

        private static native void setOffsetOnPeer(long var0, long var2);

        private static native void initNative();

        OVERLAPPED() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                OVERLAPPED.deallocatePeer(this.peer);
                this.peer = 0L;
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                super.finalize();
                throw throwable;
            }
            super.finalize();
        }

        public long getEventHandle() {
            return this.eventHandle;
        }

        public void setEvent(long eventHandle) {
            this.eventHandle = eventHandle;
            OVERLAPPED.setEventOnPeer(this.peer, eventHandle);
        }

        public long getOffset() {
            return this.offset;
        }

        public void setOffset(long offset) {
            this.offset = offset;
            OVERLAPPED.setOffsetOnPeer(this.peer, offset);
        }

        static {
            OVERLAPPED.initNative();
        }
    }
}

