/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.reporting.service;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.HierarchicalINIConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.netxms.base.EncryptedPassword;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class ServerSettings {
    public static final String DC_ID_SYSTEM = "system";
    public static final String DC_ID_SCHEDULER = "scheduler";
    public static final String DC_ID_REPORTING = "report";
    private static final Logger log = LoggerFactory.getLogger(ServerSettings.class);
    private final HierarchicalConfiguration configuration;
    private final Map<String, DataSourceConfig> dataSources = new HashMap<String, DataSourceConfig>();

    public ServerSettings() throws ConfigurationException {
        this("nxreporting.xml");
    }

    public ServerSettings(String filename) throws ConfigurationException {
        this.configuration = new XMLConfiguration(filename);
        this.loadServerConfig();
        this.loadDataSources();
        if (this.dataSources.size() > 0 && !this.dataSources.containsKey(DC_ID_SYSTEM)) {
            this.dataSources.put(DC_ID_SCHEDULER, this.dataSources.values().iterator().next());
        }
        DataSourceConfig systemConfig = this.dataSources.get(DC_ID_SYSTEM);
        if (!this.dataSources.containsKey(DC_ID_SCHEDULER)) {
            this.dataSources.put(DC_ID_SCHEDULER, systemConfig);
        }
        if (!this.dataSources.containsKey(DC_ID_REPORTING)) {
            this.dataSources.put(DC_ID_REPORTING, systemConfig);
        }
    }

    private void loadServerConfig() {
        HierarchicalINIConfiguration netxmsConfig;
        String filename = this.configuration.getString("netxmsdConfig");
        try {
            netxmsConfig = new HierarchicalINIConfiguration(filename);
        }
        catch (ConfigurationException e) {
            return;
        }
        String driver = netxmsConfig.getString("DBDriver");
        String server = netxmsConfig.getString("DBServer", "");
        String name = netxmsConfig.getString("DBName");
        String login = netxmsConfig.getString("DBLogin");
        String password = netxmsConfig.getString("DBPassword");
        DatabaseType type = this.lookupType(driver);
        if (type != null && name != null && login != null && password != null) {
            String url = null;
            switch (type) {
                case POSTGRESQL: {
                    url = "jdbc:postgresql://" + server + "/" + name;
                    break;
                }
                case ORACLE: {
                    url = "jdbc:oracle:thin:@" + server + ":1521:" + name;
                    break;
                }
                case MSSQL: {
                    url = "jdbc:sqlserver://" + server + ";DatabaseName=" + name;
                    break;
                }
                case MYSQL: {
                    url = "jdbc:mysql://" + server + "/" + name;
                    break;
                }
                case INFORMIX: {
                    url = "jdbc:informix-sqli://" + server + "/" + name;
                }
            }
            DataSourceConfig config = new DataSourceConfig(type, url, login, password);
            this.dataSources.put(DC_ID_SYSTEM, config);
            this.dataSources.put(DC_ID_SCHEDULER, config);
            this.dataSources.put(DC_ID_REPORTING, config);
        }
    }

    private void loadDataSources() {
        List dataSources = this.configuration.configurationsAt("datasources.datasource");
        for (HierarchicalConfiguration dataSource : dataSources) {
            String id = dataSource.getString("id", DC_ID_SYSTEM);
            String type = dataSource.getString("type");
            DatabaseType databaseType = this.lookupType(type);
            if (databaseType == null) continue;
            String dialect = dataSource.getString("dialect", databaseType.getDialect());
            String driver = dataSource.getString("driverClassName", databaseType.getDriver());
            String url = dataSource.getString("url");
            String username = dataSource.getString("username");
            String password = dataSource.getString("password");
            String encryptedPassword = dataSource.getString("encryptedPassword");
            if (username != null && encryptedPassword != null) {
                try {
                    password = EncryptedPassword.decrypt((String)username, (String)encryptedPassword);
                }
                catch (Exception e) {
                    log.error("Unable to decrypt password for datasource \"" + id + "\"");
                }
            }
            if (dialect == null || driver == null || url == null || username == null || password == null) continue;
            DataSourceConfig dataSourceConfig = new DataSourceConfig(databaseType, url, username, password);
            dataSourceConfig.setDialect(dialect);
            dataSourceConfig.setDriver(driver);
            this.dataSources.put(id, dataSourceConfig);
        }
    }

    private DatabaseType lookupType(String key) {
        if (key == null) {
            return null;
        }
        String lowerKey = key.toLowerCase();
        if (lowerKey.equals("postgresql") || lowerKey.contains("pgsql")) {
            return DatabaseType.POSTGRESQL;
        }
        if (lowerKey.contains("oracle")) {
            return DatabaseType.ORACLE;
        }
        if (lowerKey.contains("mssql")) {
            return DatabaseType.MSSQL;
        }
        if (lowerKey.contains("mysql")) {
            return DatabaseType.MYSQL;
        }
        if (lowerKey.contains("informix")) {
            return DatabaseType.INFORMIX;
        }
        if (lowerKey.contains("sqlite")) {
            throw new RuntimeException("SQLite not supported");
        }
        return null;
    }

    public String getWorkspace() {
        return this.configuration.getString("workspace");
    }

    public String getSmtpServer() {
        return this.configuration.getString("smtp.server", "127.0.0.1");
    }

    public String getSmtpFrom() {
        return this.configuration.getString("smtp.from", "noreply@local");
    }

    public DataSourceConfig getDataSourceConfig(String name) {
        return this.dataSources.get(name);
    }

    public Set<String> getReportingDataSources() {
        HashSet<String> set = new HashSet<String>(this.dataSources.keySet());
        set.remove(DC_ID_SCHEDULER);
        set.remove(DC_ID_SYSTEM);
        return set;
    }

    public String getNetxmsServer() {
        return this.configuration.getString("netxms.server", "127.0.0.1");
    }

    public String getNetxmsLogin() {
        return this.configuration.getString("netxms.login", "admin");
    }

    public String getNetxmsPassword() {
        String password = null;
        if (this.configuration.containsKey("netxms.encryptedPassword")) {
            try {
                password = EncryptedPassword.decrypt((String)this.getNetxmsLogin(), (String)this.configuration.getString("netxms.encryptedPassword"));
            }
            catch (Exception e) {
                log.error("Unable to decrypt netxms.encryptedPassword", (Throwable)e);
            }
        }
        return password != null ? password : this.configuration.getString("netxms.password", "");
    }

    public class DataSourceConfig {
        private String dialect;
        private String driver;
        private String url;
        private String username;
        private String password;
        private String quartzDriverDelegate;

        public DataSourceConfig(DatabaseType type, String url, String username, String password) {
            this.dialect = type.getDialect();
            this.driver = type.getDriver();
            this.url = url;
            this.username = username;
            this.password = password;
            switch (type) {
                case POSTGRESQL: {
                    this.quartzDriverDelegate = "org.quartz.impl.jdbcjobstore.PostgreSQLDelegate";
                    break;
                }
                case ORACLE: {
                    this.quartzDriverDelegate = "org.quartz.impl.jdbcjobstore.oracle.OracleDelegate";
                    break;
                }
                case MSSQL: {
                    this.quartzDriverDelegate = "org.quartz.impl.jdbcjobstore.MSSQLDelegate";
                    break;
                }
                case MYSQL: {
                    this.quartzDriverDelegate = "org.quartz.impl.jdbcjobstore.StdJDBCDelegate";
                    break;
                }
                case INFORMIX: {
                    this.quartzDriverDelegate = "org.quartz.impl.jdbcjobstore.StdJDBCDelegate";
                }
            }
        }

        public String getDialect() {
            return this.dialect;
        }

        public void setDialect(String dialect) {
            this.dialect = dialect;
        }

        public String getDriver() {
            return this.driver;
        }

        public void setDriver(String driver) {
            this.driver = driver;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getQuartzDriverDelegate() {
            return this.quartzDriverDelegate;
        }

        public String toString() {
            return "DataSourceConfig{dialect='" + this.dialect + '\'' + ", driver='" + this.driver + '\'' + ", url='" + this.url + '\'' + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + ", quartzDriverDelegate='" + this.quartzDriverDelegate + '\'' + '}';
        }
    }

    private static enum DatabaseType {
        POSTGRESQL("org.postgresql.Driver", "org.hibernate.dialect.PostgreSQL9Dialect"),
        ORACLE("oracle.jdbc.driver.OracleDriver", "org.hibernate.dialect.Oracle10gDialect"),
        MSSQL("com.microsoft.sqlserver.jdbc.SQLServerDriver", "org.hibernate.dialect.SQLServerDialect"),
        MYSQL("com.mysql.jdbc.Driver", "org.hibernate.dialect.MySQLDialect"),
        INFORMIX("com.informix.jdbc.IfxDriver", "org.hibernate.dialect.InformixDialect");

        private final String driver;
        private final String dialect;

        private DatabaseType(String driver, String dialect) {
            this.driver = driver;
            this.dialect = dialect;
        }

        public String getDriver() {
            return this.driver;
        }

        public String getDialect() {
            return this.dialect;
        }
    }
}

