/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.sf.jasperreports.components.sort.AbstractFieldComparator;
import net.sf.jasperreports.components.sort.FilterTypeDateOperatorsEnum;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.FormatUtils;

public class FieldDateComparator
extends AbstractFieldComparator<Date> {
    public FieldDateComparator(String filterPattern, Locale locale, TimeZone timeZone) {
        this.formatter = this.getFormatFactory().createDateFormat(filterPattern, locale, timeZone);
    }

    @Override
    public void initValues() throws Exception {
        if (this.valueStart != null && this.valueStart.length() > 0) {
            this.compareStart = FormatUtils.getFormattedDate((DateFormat)this.formatter, this.valueStart, this.compareToClass);
        }
        if (this.valueEnd != null && this.valueEnd.length() > 0) {
            this.compareEnd = FormatUtils.getFormattedDate((DateFormat)this.formatter, this.valueEnd, this.compareToClass);
        }
    }

    @Override
    public boolean compare(String filterTypeOperator) {
        boolean defaultResult;
        boolean result = defaultResult = true;
        boolean resultPart1 = true;
        boolean resultPart2 = true;
        try {
            this.initValues();
        }
        catch (Exception e) {
            throw new JRRuntimeException(e);
        }
        boolean validComparison = this.compareStart != null && this.compareTo != null;
        boolean validComparison2 = this.compareEnd != null && this.compareTo != null;
        Date formattedCompareTo = (Date)this.compareTo;
        if (this.compareTo != null) {
            try {
                formattedCompareTo = FormatUtils.getFormattedDate((DateFormat)this.formatter, ((DateFormat)this.formatter).format((Date)this.compareTo), this.compareToClass);
            }
            catch (ParseException e) {
                throw new JRRuntimeException(e);
            }
        }
        FilterTypeDateOperatorsEnum dateEnum = FilterTypeDateOperatorsEnum.getByEnumConstantName(filterTypeOperator);
        switch (dateEnum) {
            case EQUALS: {
                result = validComparison ? formattedCompareTo.compareTo((Date)this.compareStart) == 0 : false;
                break;
            }
            case IS_AFTER: {
                result = validComparison ? formattedCompareTo.compareTo((Date)this.compareStart) > 0 : false;
                break;
            }
            case IS_BEFORE: {
                result = validComparison ? formattedCompareTo.compareTo((Date)this.compareStart) < 0 : false;
                break;
            }
            case IS_BETWEEN: {
                boolean bl = validComparison ? formattedCompareTo.compareTo((Date)this.compareStart) >= 0 : (resultPart1 = false);
                resultPart2 = validComparison2 ? formattedCompareTo.compareTo((Date)this.compareEnd) <= 0 : false;
                result = resultPart1 && resultPart2;
                break;
            }
            case IS_NOT_BETWEEN: {
                boolean bl = validComparison ? formattedCompareTo.compareTo((Date)this.compareStart) >= 0 : (resultPart1 = false);
                resultPart2 = validComparison2 ? formattedCompareTo.compareTo((Date)this.compareEnd) <= 0 : false;
                result = !resultPart1 || !resultPart2;
                break;
            }
            case IS_NOT_EQUAL_TO: {
                result = validComparison ? formattedCompareTo.compareTo((Date)this.compareStart) != 0 : defaultResult;
                break;
            }
            case IS_ON_OR_AFTER: {
                result = validComparison ? formattedCompareTo.compareTo((Date)this.compareStart) >= 0 : false;
                break;
            }
            case IS_ON_OR_BEFORE: {
                result = validComparison ? formattedCompareTo.compareTo((Date)this.compareStart) <= 0 : false;
            }
        }
        return result;
    }
}

