/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.renderers;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.renderers.AbstractRenderer;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Graphics2DRenderable;

public class WrappingImageDataToGraphics2DRenderer
extends AbstractRenderer
implements DataRenderable,
Graphics2DRenderable,
DimensionRenderable {
    private static final long serialVersionUID = 10200L;
    private final DataRenderable dataRenderer;
    private transient SoftReference<Image> awtImageRef;

    public WrappingImageDataToGraphics2DRenderer(DataRenderable dataRenderer) throws JRException {
        this.dataRenderer = dataRenderer;
    }

    protected Image getImage(JasperReportsContext jasperReportsContext) throws JRException {
        if (this.awtImageRef == null || this.awtImageRef.get() == null) {
            Image awtImage = JRImageLoader.getInstance(jasperReportsContext).loadAwtImageFromBytes(this.getData(jasperReportsContext));
            this.awtImageRef = new SoftReference<Image>(awtImage);
        }
        return this.awtImageRef.get();
    }

    @Override
    public Dimension2D getDimension(JasperReportsContext jasperReportsContext) throws JRException {
        Image img = this.getImage(jasperReportsContext);
        return new Dimension(img.getWidth(null), img.getHeight(null));
    }

    @Override
    public byte[] getData(JasperReportsContext jasperReportsContext) throws JRException {
        return this.dataRenderer.getData(jasperReportsContext);
    }

    @Override
    public void render(JasperReportsContext jasperReportsContext, Graphics2D grx, Rectangle2D rectangle) throws JRException {
        Image img = this.getImage(jasperReportsContext);
        grx.drawImage(img, (int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight(), null);
    }
}

