/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netxms.client.NXCException;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.DciDataRow;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.websvc.handlers.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrafanaDataCollection
extends AbstractHandler {
    private List<AbstractObject> objects;
    private Logger log = LoggerFactory.getLogger(GrafanaDataCollection.class);

    protected Object getCollection(Map<String, String> query) throws Exception {
        if (!this.getSession().isObjectsSynchronized()) {
            this.getSession().syncObjects();
        }
        this.objects = this.getSession().getAllObjects();
        if (query.containsKey("targets")) {
            return this.getGraphData(query);
        }
        if (query.containsKey("target")) {
            return this.getDciList(query.get("target"));
        }
        return this.getNodeList();
    }

    private JsonArray getGraphData(Map<String, String> query) throws Exception {
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(query.get("targets"));
        if (!element.isJsonArray()) {
            return new JsonArray();
        }
        JsonArray targets = element.getAsJsonArray();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        Date from = format.parse(query.get("from").substring(1, query.get("from").length() - 1));
        Date to = format.parse(query.get("to").substring(1, query.get("to").length() - 1));
        JsonArray result = new JsonArray();
        for (JsonElement e : targets) {
            if (!e.getAsJsonObject().has("dciTarget") || !e.getAsJsonObject().has("dci")) continue;
            JsonObject dciTarget = e.getAsJsonObject().getAsJsonObject("dciTarget");
            JsonObject dci = e.getAsJsonObject().getAsJsonObject("dci");
            if (dciTarget.size() == 0 || dci.size() == 0) continue;
            DciData data = this.getSession().getCollectedData(Long.parseLong(dciTarget.get("id").getAsString()), Long.parseLong(dci.get("id").getAsString()), from, to, 0);
            JsonObject root = new JsonObject();
            JsonArray datapoints = new JsonArray();
            for (DciDataRow r : data.getValues()) {
                JsonArray datapoint = new JsonArray();
                datapoint.add((Number)r.getValueAsDouble());
                datapoint.add((Number)r.getTimestamp().getTime());
                datapoints.add((JsonElement)datapoint);
            }
            if (e.getAsJsonObject().has("legend") && !e.getAsJsonObject().get("legend").getAsString().equals("")) {
                root.addProperty("target", e.getAsJsonObject().get("legend").getAsString());
            } else {
                root.addProperty("target", dci.get("name").getAsString());
            }
            root.add("datapoints", (JsonElement)datapoints);
            result.add((JsonElement)root);
        }
        return result;
    }

    private Map<Long, String> getNodeList() {
        HashMap<Long, String> result = new HashMap<Long, String>();
        for (AbstractObject o : this.objects) {
            if (!(o instanceof DataCollectionTarget)) continue;
            result.put(o.getObjectId(), o.getObjectName());
        }
        return result;
    }

    private Map<Long, String> getDciList(String id) throws Exception {
        HashMap<Long, String> result = new HashMap<Long, String>();
        try {
            DciValue[] values;
            for (DciValue v : values = this.getSession().getLastValues(Long.parseLong(id))) {
                result.put(v.getId(), v.getDescription());
            }
        }
        catch (NXCException e) {
            this.log.debug("DCI not found");
        }
        return result;
    }
}

