/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.internal.model.Fraction;

public class ContinuedFraction {
    private double decimal = 0.0;
    private List<Long> integerList = new ArrayList<Long>();

    public ContinuedFraction(double decimal) {
        this.decimal = ValueFormatter.normalizeDouble(decimal).doubleValue();
        this.computeList();
    }

    public Fraction getExactFraction() {
        int lastIndex = this.integerList.size() - 1;
        return this.getFraction(lastIndex, new Fraction(this.integerList.get(lastIndex).intValue(), 1L));
    }

    public Fraction getFractionWithMaxDigits(int maxDigitsForDenominator) {
        int lastIndex = this.integerList.size();
        Fraction previousFraction = null;
        int i = 0;
        while (i < lastIndex) {
            Fraction fraction = this.getFraction(i, new Fraction(this.integerList.get(i).intValue(), 1L));
            if (fraction.getDenominatorDigits() > (long)maxDigitsForDenominator) {
                return previousFraction;
            }
            previousFraction = fraction;
            ++i;
        }
        return previousFraction;
    }

    private Fraction getFraction(int index, Fraction fraction) {
        if (index > 0) {
            return this.getFraction(index - 1, fraction.invert().add(this.integerList.get(index - 1)));
        }
        return fraction;
    }

    private void computeList() {
        int decimalDigits = 0;
        double decimalTemp = this.decimal;
        while (Math.abs(Math.ceil(decimalTemp) - decimalTemp) > Math.pow(10.0, decimalDigits - 8)) {
            decimalTemp *= 10.0;
            ++decimalDigits;
        }
        long dividend = (long)Math.pow(10.0, decimalDigits);
        long start = (long)decimalTemp;
        long quotient = 0L;
        long oldDividend = 0L;
        do {
            quotient = start / dividend;
            this.integerList.add(quotient);
            oldDividend = dividend;
            dividend = start % dividend;
            start = oldDividend;
        } while (dividend != 0L);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        for (long l : this.integerList) {
            s.append(l).append(',');
        }
        if (this.integerList.size() > 0) {
            s.deleteCharAt(s.length() - 1);
        }
        return s.toString();
    }
}

