/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.net.InetAddress;
import java.util.UUID;
import org.netxms.base.NXCPMessage;

public class AgentTunnel {
    private int id;
    private UUID guid;
    private InetAddress address;
    private long nodeId;
    private String systemName;
    private String systemInformation;
    private String platformName;
    private String agentVersion;
    private int activeChannelCount;

    protected AgentTunnel(NXCPMessage msg, long baseId) {
        this.id = msg.getFieldAsInt32(baseId);
        this.guid = msg.getFieldAsUUID(baseId + 1L);
        this.nodeId = msg.getFieldAsInt64(baseId + 2L);
        this.address = msg.getFieldAsInetAddress(baseId + 3L);
        this.systemName = msg.getFieldAsString(baseId + 4L);
        this.systemInformation = msg.getFieldAsString(baseId + 5L);
        this.platformName = msg.getFieldAsString(baseId + 6L);
        this.agentVersion = msg.getFieldAsString(baseId + 7L);
        this.activeChannelCount = msg.getFieldAsInt32(baseId + 8L);
    }

    public boolean isBound() {
        return this.nodeId != 0L;
    }

    public int getId() {
        return this.id;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getSystemInformation() {
        return this.systemInformation;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public int getActiveChannelCount() {
        return this.activeChannelCount;
    }

    public String toString() {
        return "AgentTunnel [id=" + this.id + ", guid=" + this.guid + ", address=" + this.address + ", nodeId=" + this.nodeId + ", systemName=" + this.systemName + ", systemInformation=" + this.systemInformation + ", platformName=" + this.platformName + ", agentVersion=" + this.agentVersion + ", activeChannelCount=" + this.activeChannelCount + "]";
    }
}

