/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netxms.client.MacAddressFormatException;

public class MacAddress {
    private byte[] value;

    public MacAddress() {
        this.value = new byte[6];
        Arrays.fill(this.value, (byte)0);
    }

    public MacAddress(byte[] src) {
        if (src != null) {
            this.value = Arrays.copyOf(src, 6);
        } else {
            this.value = new byte[6];
            Arrays.fill(this.value, (byte)0);
        }
    }

    public boolean isNull() {
        byte[] byArray = this.value;
        int n = this.value.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int ub = this.value[0] & 0xFF;
        if (ub < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(ub));
        int i = 1;
        while (i < this.value.length) {
            sb.append(':');
            ub = this.value[i] & 0xFF;
            if (ub < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(ub));
            ++i;
        }
        return sb.toString().toUpperCase();
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof MacAddress) {
            return Arrays.equals(this.value, ((MacAddress)arg0).value);
        }
        return super.equals(arg0);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public static MacAddress parseMacAddress(String str) throws MacAddressFormatException {
        Pattern pattern = Pattern.compile("^([0-9a-fA-F]{2})[ :\\-]?([0-9a-fA-F]{2})[ :\\-]?([0-9a-fA-F]{2})[ :\\-]?([0-9a-fA-F]{2})[ :\\-]?([0-9a-fA-F]{2})[ :\\-]?([0-9a-fA-F]{2})$");
        Matcher matcher = pattern.matcher(str.trim());
        if (matcher.matches()) {
            byte[] bytes = new byte[6];
            try {
                int i = 0;
                while (i < 6) {
                    bytes[i] = (byte)Integer.parseInt(matcher.group(i + 1), 16);
                    ++i;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new MacAddressFormatException();
            }
            return new MacAddress(bytes);
        }
        pattern = Pattern.compile("^([0-9a-fA-F]{3})\\.([0-9a-fA-F]{3})\\.([0-9a-fA-F]{3})\\.([0-9a-fA-F]{3})$");
        matcher = pattern.matcher(str.trim());
        if (matcher.matches()) {
            byte[] bytes = new byte[6];
            try {
                int j = 0;
                int i = 1;
                while (i <= 4) {
                    int left = Integer.parseInt(matcher.group(i), 16);
                    int right = Integer.parseInt(matcher.group(i + 1), 16);
                    bytes[j++] = (byte)(left >> 4);
                    bytes[j++] = (byte)((left & 0xF) << 4 | right >> 8);
                    bytes[j++] = (byte)(right & 0xFF);
                    i += 2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new MacAddressFormatException();
            }
            return new MacAddress(bytes);
        }
        throw new MacAddressFormatException();
    }

    public byte[] getValue() {
        return Arrays.copyOf(this.value, 6);
    }

    public int compareTo(MacAddress dst) {
        if (dst == null) {
            return 1;
        }
        int len = Math.min(this.value.length, dst.value.length);
        int i = 0;
        while (i < len) {
            int v1 = this.value[i] & 0xFF;
            int v2 = dst.value[i] & 0xFF;
            if (v1 < v2) {
                return -1;
            }
            if (v1 > v2) {
                return 1;
            }
            ++i;
        }
        return this.value.length - dst.value.length;
    }
}

