/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.elements;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.netxms.client.ObjectUrl;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.OverviewPageElement;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class ExternalResources
extends OverviewPageElement {
    private Composite content;
    private List<Element> elements = new ArrayList<Element>();

    public ExternalResources(Composite parent, OverviewPageElement anchor, ObjectTab objectTab) {
        super(parent, anchor, objectTab);
    }

    @Override
    protected String getTitle() {
        return "External Resources";
    }

    @Override
    public boolean isApplicableForObject(AbstractObject object) {
        return object != null && object.hasUrls();
    }

    @Override
    protected Control createClientArea(Composite parent) {
        this.content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.content.setLayout((Layout)layout);
        this.content.setBackground(SharedColors.getColor((String)"ObjectTab.Background", (Display)parent.getDisplay()));
        return this.content;
    }

    @Override
    protected void onObjectChange() {
        for (Element e : this.elements) {
            e.dispose();
        }
        this.elements.clear();
        for (ObjectUrl u : this.getObject().getUrls()) {
            this.elements.add(new Element(this.content, u));
        }
        this.content.layout();
    }

    private void openUrl(URL url) {
        try {
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
        }
        catch (PartInitException e) {
            Activator.log("Exception when trying to open URL " + url.toExternalForm(), (Exception)((Object)e));
            MessageDialogHelper.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)"Cannot start external web browser");
        }
    }

    private class Element {
        ObjectUrl url;
        Hyperlink link;
        Label description;

        Element(Composite parent, ObjectUrl url) {
            this.url = url;
            this.link = new Hyperlink(parent, 0);
            this.link.setBackground(ExternalResources.this.content.getBackground());
            this.link.setForeground(SharedColors.getColor((String)"CommandBox.Text", (Display)this.link.getDisplay()));
            this.link.setText(url.getUrl().toExternalForm());
            this.link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    ExternalResources.this.openUrl(Element.this.url.getUrl());
                }
            });
            this.description = new Label(parent, 0);
            this.description.setBackground(ExternalResources.this.content.getBackground());
            this.description.setText(url.getDescription());
        }

        void dispose() {
            this.link.dispose();
            this.description.dispose();
        }
    }
}

