/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.datacollection.TableThreshold;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.dialogs.EditTableThresholdDialog;
import org.netxms.ui.eclipse.datacollection.propertypages.helpers.DCIPropertyPageDialog;
import org.netxms.ui.eclipse.datacollection.propertypages.helpers.TableThresholdLabelProvider;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class TableThresholds
extends DCIPropertyPageDialog {
    private static final String COLUMN_SETTINGS_PREFIX = "TableThresholds.ColumnList";
    private DataCollectionTable dci;
    private List<TableThreshold> thresholds;
    private TableViewer thresholdList;
    private Button addButton;
    private Button modifyButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;

    @Override
    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dci = this.editor.getObjectAsTable();
        this.thresholds = new ArrayList<TableThreshold>();
        for (TableThreshold t : this.dci.getThresholds()) {
            this.thresholds.add(new TableThreshold(t));
        }
        Platform.getAdapterManager().loadAdapter((Object)new EventTemplate(0L), "org.eclipse.ui.model.IWorkbenchAdapter");
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        Composite thresholdListArea = new Composite(dialogArea, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        thresholdListArea.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        thresholdListArea.setLayout((Layout)layout);
        Label label = new Label(thresholdListArea, 0);
        Messages.get();
        label.setText(Messages.TableThresholds_Thresholds);
        this.thresholdList = new TableViewer(thresholdListArea, 67586);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.thresholdList.getControl().setLayoutData((Object)gd);
        this.setupThresholdList();
        this.thresholdList.setInput((Object)this.thresholds.toArray());
        Composite leftButtons = new Composite(thresholdListArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gd);
        RowLayout buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        leftButtons.setLayout((Layout)buttonsLayout);
        this.upButton = new Button(leftButtons, 8);
        Messages.get();
        this.upButton.setText(Messages.TableThresholds_Up);
        RowData rd = new RowData();
        rd.width = 90;
        this.upButton.setLayoutData((Object)rd);
        this.upButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableThresholds.this.moveSelectionUp();
            }
        });
        this.downButton = new Button(leftButtons, 8);
        Messages.get();
        this.downButton.setText(Messages.TableThresholds_Down);
        rd = new RowData();
        rd.width = 90;
        this.downButton.setLayoutData((Object)rd);
        this.downButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableThresholds.this.moveSelectionDown();
            }
        });
        Composite buttons = new Composite(thresholdListArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        buttons.setLayout((Layout)buttonsLayout);
        this.addButton = new Button(buttons, 8);
        Messages.get();
        this.addButton.setText(Messages.TableThresholds_Add);
        rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableThresholds.this.addThreshold();
            }
        });
        this.modifyButton = new Button(buttons, 8);
        Messages.get();
        this.modifyButton.setText(Messages.TableThresholds_Edit);
        rd = new RowData();
        rd.width = 90;
        this.modifyButton.setLayoutData((Object)rd);
        this.modifyButton.setEnabled(false);
        this.modifyButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableThresholds.this.editThreshold();
            }
        });
        this.deleteButton = new Button(buttons, 8);
        Messages.get();
        this.deleteButton.setText(Messages.TableThresholds_Delete);
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableThresholds.this.deleteThresholds();
            }
        });
        this.thresholdList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                TableThresholds.this.deleteButton.setEnabled(selection.size() > 0);
                if (selection.size() == 1) {
                    TableThresholds.this.modifyButton.setEnabled(true);
                    TableThresholds.this.upButton.setEnabled(TableThresholds.this.thresholds.indexOf(selection.getFirstElement()) > 0);
                    TableThresholds.this.downButton.setEnabled(TableThresholds.this.thresholds.indexOf(selection.getFirstElement()) < TableThresholds.this.thresholds.size() - 1);
                } else {
                    TableThresholds.this.modifyButton.setEnabled(false);
                    TableThresholds.this.upButton.setEnabled(false);
                    TableThresholds.this.downButton.setEnabled(false);
                }
            }
        });
        this.thresholdList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TableThresholds.this.editThreshold();
            }
        });
        return dialogArea;
    }

    private void setupThresholdList() {
        Table table = this.thresholdList.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        Messages.get();
        column.setText(Messages.TableThresholds_Condition);
        column.setWidth(200);
        column = new TableColumn(table, 16384);
        column.setText("Samples");
        column.setWidth(90);
        column = new TableColumn(table, 16384);
        Messages.get();
        column.setText(Messages.TableThresholds_ActivationEvent);
        column.setWidth(140);
        column = new TableColumn(table, 16384);
        Messages.get();
        column.setText(Messages.TableThresholds_DeactivationEvent);
        column.setWidth(140);
        WidgetHelper.restoreColumnSettings((Table)table, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)COLUMN_SETTINGS_PREFIX);
        this.thresholdList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.thresholdList.setLabelProvider((IBaseLabelProvider)new TableThresholdLabelProvider());
    }

    private void deleteThresholds() {
        IStructuredSelection selection = (IStructuredSelection)this.thresholdList.getSelection();
        if (!selection.isEmpty()) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                this.thresholds.remove(it.next());
            }
            this.thresholdList.setInput((Object)this.thresholds.toArray());
        }
    }

    private void editThreshold() {
        IStructuredSelection selection = (IStructuredSelection)this.thresholdList.getSelection();
        if (selection.size() == 1) {
            TableThreshold t = (TableThreshold)selection.getFirstElement();
            EditTableThresholdDialog dlg = new EditTableThresholdDialog(this.getShell(), t, this.editor.getCallback());
            if (dlg.open() == 0) {
                this.thresholdList.update((Object)t, null);
            }
        }
    }

    private void addThreshold() {
        TableThreshold t = new TableThreshold();
        EditTableThresholdDialog dlg = new EditTableThresholdDialog(this.getShell(), t, this.editor.getCallback());
        if (dlg.open() == 0) {
            this.thresholds.add(t);
            this.thresholdList.setInput((Object)this.thresholds.toArray());
            this.thresholdList.setSelection((ISelection)new StructuredSelection((Object)t));
        }
    }

    private void moveSelectionUp() {
        IStructuredSelection selection = (IStructuredSelection)this.thresholdList.getSelection();
        if (selection.size() != 1) {
            return;
        }
        TableThreshold t = (TableThreshold)selection.getFirstElement();
        int index = this.thresholds.indexOf(t);
        if (index > 0) {
            Collections.swap(this.thresholds, index, index - 1);
            this.thresholdList.setInput((Object)this.thresholds.toArray());
            this.thresholdList.setSelection((ISelection)new StructuredSelection((Object)t));
        }
    }

    private void moveSelectionDown() {
        IStructuredSelection selection = (IStructuredSelection)this.thresholdList.getSelection();
        if (selection.size() != 1) {
            return;
        }
        TableThreshold t = (TableThreshold)selection.getFirstElement();
        int index = this.thresholds.indexOf(t);
        if (index < this.thresholds.size() - 1) {
            Collections.swap(this.thresholds, index, index + 1);
            this.thresholdList.setInput((Object)this.thresholds.toArray());
            this.thresholdList.setSelection((ISelection)new StructuredSelection((Object)t));
        }
    }

    protected void applyChanges(boolean isApply) {
        this.dci.getThresholds().clear();
        this.dci.getThresholds().addAll(this.thresholds);
        this.editor.modify();
    }

    protected void performApply() {
        this.saveSettings();
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.saveSettings();
        this.applyChanges(false);
        return true;
    }

    public boolean performCancel() {
        this.saveSettings();
        return true;
    }

    private void saveSettings() {
        WidgetHelper.saveColumnSettings((Table)this.thresholdList.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)COLUMN_SETTINGS_PREFIX);
    }
}

