/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.objecttabs;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.widgets.AlarmList;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.tools.VisibilityValidator;

public class AlarmTab
extends ObjectTab {
    private AlarmList alarmList;
    private IPropertyChangeListener propertyChangeListener;

    protected void createTabContent(Composite parent) {
        this.alarmList = new AlarmList((IViewPart)this.getViewPart(), parent, 0, this.getConfigPrefix(), new VisibilityValidator(){

            public boolean isVisible() {
                return AlarmTab.this.isActive();
            }
        });
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("SHOW_ALARM_STATUS_COLORS")) {
                    ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    service.refreshElements("org.netxms.ui.eclipse.alarmviewer.commands.show_status_colors", null);
                }
            }
        };
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    protected String getConfigPrefix() {
        return "AlarmTab";
    }

    public void objectChanged(AbstractObject object) {
        if (object != null && this.isActive()) {
            this.alarmList.setRootObject(object.getObjectId());
        }
    }

    public void selected() {
        super.selected();
        if (this.getObject() != null) {
            this.alarmList.setRootObject(this.getObject().getObjectId());
        }
    }

    public void refresh() {
        this.alarmList.refresh();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.alarmList.getSelectionProvider();
    }

    public boolean showForObject(AbstractObject object) {
        return object.isAlarmsVisible();
    }

    public void dispose() {
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        if (this.alarmList != null) {
            this.alarmList.dispose();
        }
        super.dispose();
    }

    public void setShowColors(boolean show) {
        this.alarmList.setShowColors(show);
    }
}

