/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.netxms.client.constants.ColumnFilterSetOperation;
import org.netxms.client.log.ColumnFilter;
import org.netxms.client.log.LogColumn;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.logviewer.Messages;
import org.netxms.ui.eclipse.logviewer.widgets.AlarmHDStateConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.AlarmStateConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.ConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.EventConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.FilterBuilder;
import org.netxms.ui.eclipse.logviewer.widgets.IntegerConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.ObjectConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.SeverityConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.TextConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.TimestampConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.UserConditionEditor;
import org.netxms.ui.eclipse.widgets.DashboardComposite;

public class ColumnFilterEditor
extends DashboardComposite {
    private FormToolkit toolkit;
    private LogColumn column;
    private FilterBuilder filterBuilder;
    private List<ConditionEditor> conditions = new ArrayList<ConditionEditor>();
    private ColumnFilterSetOperation booleanOperation = ColumnFilterSetOperation.OR;

    public ColumnFilterEditor(Composite parent, FormToolkit toolkit, LogColumn column, ColumnFilterSetOperation operation, final Runnable deleteHandler) {
        super(parent, 2048);
        this.toolkit = toolkit;
        this.column = column;
        this.booleanOperation = operation;
        toolkit.adapt((Composite)this);
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        Composite header = toolkit.createComposite((Composite)this);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 5;
        header.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        header.setLayoutData((Object)gd);
        Label title = toolkit.createLabel(header, column.getDescription());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        title.setLayoutData((Object)gd);
        Composite buttons = toolkit.createComposite(header);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        buttons.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        gd.grabExcessHorizontalSpace = true;
        buttons.setLayoutData((Object)gd);
        Messages.get();
        Button radioAnd = toolkit.createButton(buttons, Messages.ColumnFilterEditor_AndCondition, 16);
        radioAnd.setSelection(this.booleanOperation == ColumnFilterSetOperation.AND);
        radioAnd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnFilterEditor.this.setBooleanOperation(ColumnFilterSetOperation.AND);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Messages.get();
        Button radioOr = toolkit.createButton(buttons, Messages.ColumnFilterEditor_OrCondition, 16);
        radioOr.setSelection(this.booleanOperation == ColumnFilterSetOperation.OR);
        radioOr.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnFilterEditor.this.setBooleanOperation(ColumnFilterSetOperation.OR);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        ImageHyperlink link = toolkit.createImageHyperlink(header, 0);
        link.setImage(SharedIcons.IMG_ADD_OBJECT);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ColumnFilterEditor.this.addCondition(null);
            }
        });
        link = toolkit.createImageHyperlink(header, 0);
        link.setImage(SharedIcons.IMG_DELETE_OBJECT);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ColumnFilterEditor.this.dispose();
                deleteHandler.run();
            }
        });
    }

    private void setBooleanOperation(ColumnFilterSetOperation op) {
        String string;
        this.booleanOperation = op;
        if (op == ColumnFilterSetOperation.AND) {
            Messages.get();
            string = Messages.ColumnFilterEditor_And;
        } else {
            Messages.get();
            string = Messages.ColumnFilterEditor_Or;
        }
        String opName = string;
        int i = 1;
        while (i < this.conditions.size()) {
            this.conditions.get(i).setLogicalOperation(opName);
            ++i;
        }
    }

    private void addCondition(ColumnFilter initialFilter) {
        final ConditionEditor ce = this.createConditionEditor(initialFilter);
        ce.setDeleteHandler(new Runnable(){

            @Override
            public void run() {
                ColumnFilterEditor.this.conditions.remove((Object)ce);
                if (ColumnFilterEditor.this.conditions.size() > 0) {
                    ((ConditionEditor)((Object)ColumnFilterEditor.this.conditions.get(0))).setLogicalOperation("");
                }
                ColumnFilterEditor.this.filterBuilder.updateLayout();
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        ce.setLayoutData(gd);
        this.conditions.add(ce);
        if (this.conditions.size() > 1) {
            String string;
            if (this.booleanOperation == ColumnFilterSetOperation.AND) {
                Messages.get();
                string = Messages.ColumnFilterEditor_And;
            } else {
                Messages.get();
                string = Messages.ColumnFilterEditor_Or;
            }
            ce.setLogicalOperation(string);
        }
        this.filterBuilder.updateLayout();
    }

    private ConditionEditor createConditionEditor(ColumnFilter initialFilter) {
        ConditionEditor editor;
        switch (this.column.getType()) {
            case 8: {
                editor = new AlarmHDStateConditionEditor((Composite)this, this.toolkit);
                break;
            }
            case 7: {
                editor = new AlarmStateConditionEditor((Composite)this, this.toolkit);
                break;
            }
            case 4: {
                editor = new EventConditionEditor((Composite)this, this.toolkit);
                break;
            }
            case 6: {
                editor = new IntegerConditionEditor((Composite)this, this.toolkit);
                break;
            }
            case 2: {
                editor = new ObjectConditionEditor((Composite)this, this.toolkit);
                break;
            }
            case 1: {
                editor = new SeverityConditionEditor((Composite)this, this.toolkit);
                break;
            }
            case 5: {
                editor = new TimestampConditionEditor((Composite)this, this.toolkit);
                break;
            }
            case 3: {
                editor = new UserConditionEditor((Composite)this, this.toolkit);
                break;
            }
            default: {
                editor = new TextConditionEditor((Composite)this, this.toolkit);
            }
        }
        editor.initialize(initialFilter);
        return editor;
    }

    public void attachFilterBuilder(FilterBuilder filterBuilder, ColumnFilter initialFilter) {
        this.filterBuilder = filterBuilder;
        if (initialFilter == null || initialFilter.getSubFilters() == null) {
            this.addCondition(null);
        } else {
            for (ColumnFilter f : initialFilter.getSubFilters()) {
                f.setOperation(f.getOperation());
                this.addCondition(f);
            }
        }
    }

    public ColumnFilter buildFilterTree() {
        if (this.conditions.size() == 0) {
            return null;
        }
        if (this.conditions.size() > 1) {
            ColumnFilter root = new ColumnFilter();
            root.setOperation(this.booleanOperation);
            for (ConditionEditor e : this.conditions) {
                ColumnFilter filter = e.createFilter();
                root.addSubFilter(filter);
            }
            return root;
        }
        return this.conditions.get(0).createFilter();
    }
}

