/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.widgets.helpers;

import java.text.NumberFormat;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.TableColumnDefinition;
import org.netxms.client.TableRow;

public class TableLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableFontProvider {
    private TableColumnDefinition[] columns = null;
    private Font keyColumnFont;
    private boolean useMultipliers = true;

    public TableLabelProvider() {
        FontData fd = JFaceResources.getDefaultFont().getFontData()[0];
        fd.setStyle(1);
        this.keyColumnFont = new Font((Device)Display.getCurrent(), fd);
    }

    public void dispose() {
        this.keyColumnFont.dispose();
        super.dispose();
    }

    public void setColumns(TableColumnDefinition[] columns) {
        this.columns = columns;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        TableRow row = (TableRow)element;
        if (columnIndex >= row.size()) {
            return null;
        }
        if (this.useMultipliers) {
            return this.getValueForFormat(row, columnIndex);
        }
        return row.get(columnIndex).getValue();
    }

    public Font getFont(Object element, int columnIndex) {
        if (this.columns == null || columnIndex >= this.columns.length) {
            return null;
        }
        if (this.columns[columnIndex].isInstanceColumn()) {
            return this.keyColumnFont;
        }
        return null;
    }

    public void setUseMultipliers(boolean useMultipliers) {
        this.useMultipliers = useMultipliers;
    }

    public boolean areMultipliersUsed() {
        return this.useMultipliers;
    }

    private String getValueForFormat(TableRow row, int columnIndex) {
        String value;
        String suffix = null;
        try {
            switch (this.columns[columnIndex].getDataType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    long i = Long.parseLong(row.get(columnIndex).getValue());
                    if (i >= 10000000000000L || i <= -10000000000000L) {
                        i /= 1000000000000L;
                        suffix = "T";
                    }
                    if (i >= 10000000000L || i <= -10000000000L) {
                        i /= 1000000000L;
                        suffix = "G";
                    }
                    if (i >= 10000000L || i <= -10000000L) {
                        i /= 1000000L;
                        suffix = "M";
                    }
                    if (i >= 10000L || i <= -10000L) {
                        i /= 1000L;
                        suffix = "K";
                    }
                    value = Long.toString(i);
                    break;
                }
                case 5: {
                    double d = Double.parseDouble(row.get(columnIndex).getValue());
                    NumberFormat nf = NumberFormat.getNumberInstance();
                    nf.setMaximumFractionDigits(2);
                    if (d >= 1.0E13 || d <= -1.0E13) {
                        d /= 1.0E12;
                        suffix = "T";
                    }
                    if (d >= 1.0E10 || d <= -1.0E10) {
                        d /= 1.0E9;
                        suffix = "G";
                    }
                    if (d >= 1.0E7 || d <= -1.0E7) {
                        d /= 1000000.0;
                        suffix = "M";
                    }
                    if (d >= 10000.0 || d <= -10000.0) {
                        d /= 1000.0;
                        suffix = "K";
                    }
                    value = Double.toString(d);
                    break;
                }
                default: {
                    value = row.get(columnIndex).getValue();
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            value = row.get(columnIndex).getValue();
        }
        if (suffix != null) {
            return String.valueOf(value) + " " + suffix;
        }
        return value;
    }
}

