/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.xml.JRXmlTemplateLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFillReportTemplate
implements JRReportTemplate {
    private static final Log log = LogFactory.getLog(JRFillReportTemplate.class);
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_TEMPLATE_SOURCE = "fill.report.template.unknown.template.source";
    private final JRReportTemplate parent;
    private final JRBaseFiller filler;

    public JRFillReportTemplate(JRReportTemplate template, JRBaseFiller filler, JRFillObjectFactory factory) {
        factory.put(template, this);
        this.parent = template;
        this.filler = filler;
    }

    @Override
    public JRExpression getSourceExpression() {
        return this.parent.getSourceExpression();
    }

    public JRTemplate evaluate() throws JRException {
        JRExpression sourceExpression = this.getSourceExpression();
        Object source = this.filler.evaluateExpression(sourceExpression, (byte)3);
        JRTemplate template = source == null ? null : (source instanceof JRTemplate ? (JRTemplate)source : JRFillReportTemplate.loadTemplate(source, this.filler));
        return template;
    }

    protected static JRTemplate loadTemplate(Object source, JRBaseFiller filler) throws JRException {
        JRTemplate template;
        if (filler.fillContext.hasLoadedTemplate(source)) {
            template = filler.fillContext.getLoadedTemplate(source);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading styles template from " + source));
            }
            if (source instanceof String) {
                template = JRXmlTemplateLoader.getInstance(filler.getJasperReportsContext()).loadTemplate((String)source);
            } else if (source instanceof File) {
                template = JRXmlTemplateLoader.getInstance(filler.getJasperReportsContext()).loadTemplate((File)source);
            } else if (source instanceof URL) {
                template = JRXmlTemplateLoader.getInstance(filler.getJasperReportsContext()).loadTemplate((URL)source);
            } else if (source instanceof InputStream) {
                template = JRXmlTemplateLoader.getInstance(filler.getJasperReportsContext()).loadTemplate((InputStream)source);
            } else {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNKNOWN_TEMPLATE_SOURCE, new Object[]{source.getClass().getName()});
            }
            filler.fillContext.registerLoadedTemplate(source, template);
        }
        return template;
    }
}

