/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.snmp.MibObject;
import org.netxms.client.snmp.SnmpValue;
import org.netxms.ui.eclipse.snmp.SnmpConstants;
import org.netxms.ui.eclipse.snmp.shared.MibCache;

public class SnmpValueLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        SnmpValue value = (SnmpValue)element;
        switch (columnIndex) {
            case 0: {
                return value.getName();
            }
            case 1: {
                MibObject object = MibCache.findObject(value.getName(), false);
                if (object == null) {
                    return "";
                }
                return object.getFullName();
            }
            case 2: {
                if (value.getType() == 65535) {
                    return "Hex-STRING";
                }
                return SnmpConstants.getAsnTypeName(value.getType());
            }
            case 3: {
                return value.getValue();
            }
        }
        return null;
    }
}

