/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.views;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.AgentTunnel;
import org.netxms.client.NXCObjectCreationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.agentmanager.Activator;
import org.netxms.ui.eclipse.agentmanager.views.helpers.TunnelListComparator;
import org.netxms.ui.eclipse.agentmanager.views.helpers.TunnelListLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectmanager.dialogs.CreateNodeDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class TunnelManager
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.agentmanager.views.TunnelManager";
    public static final int COL_ID = 0;
    public static final int COL_STATE = 1;
    public static final int COL_NODE = 2;
    public static final int COL_IP_ADDRESS = 3;
    public static final int COL_CHANNELS = 4;
    public static final int COL_SYSNAME = 5;
    public static final int COL_PLATFORM = 6;
    public static final int COL_SYSINFO = 7;
    public static final int COL_AGENT_VERSION = 8;
    private SortableTableViewer viewer;
    private Action actionRefresh;
    private Action actionCreateNode;
    private Action actionBind;
    private Action actionUnbind;

    public void createPartControl(Composite parent) {
        String[] names = new String[]{"ID", "State", "Node", "IP address", "Channels", "System name", "Platform", "System information", "Agent version"};
        int[] widths = new int[]{80, 80, 140, 150, 80, 150, 150, 300, 150};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TunnelListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new TunnelListComparator());
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)settings, (String)"TunnelManager");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)TunnelManager.this.viewer, (IDialogSettings)settings, (String)"TunnelManager");
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.refresh();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                TunnelManager.this.refresh();
            }
        };
        this.actionCreateNode = new Action("&Create node and bind..."){

            public void run() {
                TunnelManager.this.createNode();
            }
        };
        this.actionBind = new Action("&Bind to..."){

            public void run() {
                TunnelManager.this.bindTunnel();
            }
        };
        this.actionUnbind = new Action("&Unbind"){

            public void run() {
                TunnelManager.this.unbindTunnel();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                TunnelManager.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && !((AgentTunnel)selection.getFirstElement()).isBound()) {
            manager.add((IAction)this.actionBind);
            manager.add((IAction)this.actionCreateNode);
        } else {
            for (Object o : selection.toList()) {
                if (!((AgentTunnel)o).isBound()) continue;
                manager.add((IAction)this.actionUnbind);
                break;
            }
        }
    }

    private void refresh() {
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Get list of active agent tunnels", (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List tunnels = session.getAgentTunnels();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        TunnelManager.this.viewer.setInput((Object)tunnels);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get list of active agent tunnels";
            }
        }.start();
    }

    private void createNode() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final AgentTunnel tunnel = (AgentTunnel)selection.getFirstElement();
        if (tunnel.isBound()) {
            return;
        }
        CreateNodeDialog dlg = new CreateNodeDialog(this.getSite().getShell(), null);
        dlg.setEnableShowAgainFlag(false);
        dlg.setObjectName(tunnel.getSystemName());
        dlg.setZoneUIN(tunnel.getZoneUIN());
        if (dlg.open() != 0) {
            return;
        }
        final NXCObjectCreationData cd = new NXCObjectCreationData(2, dlg.getObjectName(), 2L);
        cd.setCreationFlags(dlg.getCreationFlags());
        cd.setPrimaryName(dlg.getHostName());
        cd.setAgentPort(dlg.getAgentPort());
        cd.setSnmpPort(dlg.getSnmpPort());
        cd.setAgentProxyId(dlg.getAgentProxy());
        cd.setSnmpProxyId(dlg.getSnmpProxy());
        cd.setIcmpProxyId(dlg.getIcmpProxy());
        cd.setSshProxyId(dlg.getSshProxy());
        cd.setZoneUIN(dlg.getZoneUIN());
        cd.setSshLogin(dlg.getSshLogin());
        cd.setSshPassword(dlg.getSshPassword());
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Create new node and bind tunnel", (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                long nodeId = session.createObject(cd);
                session.bindAgentTunnel(tunnel.getId(), nodeId);
                final List tunnels = session.getAgentTunnels();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        TunnelManager.this.viewer.setInput((Object)tunnels);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot create node and bind tunnel";
            }
        }.start();
    }

    private void bindTunnel() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final AgentTunnel tunnel = (AgentTunnel)selection.getFirstElement();
        if (tunnel.isBound()) {
            return;
        }
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getSite().getShell(), null, ObjectSelectionDialog.createNodeSelectionFilter((boolean)false));
        if (dlg.open() != 0) {
            return;
        }
        final long nodeId = ((AbstractObject)dlg.getSelectedObjects().get(0)).getObjectId();
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Bind tunnels", (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.bindAgentTunnel(tunnel.getId(), nodeId);
                final List tunnels = session.getAgentTunnels();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        TunnelManager.this.viewer.setInput((Object)tunnels);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot bind tunnel";
            }
        }.start();
    }

    private void unbindTunnel() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Unbind Tunnel", (String)"Selected tunnels will be unbound. Are you sure?")) {
            return;
        }
        final Object[] tunnels = selection.toArray();
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Unbind tunnels", (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Object[] objectArray = tunnels;
                int n = tunnels.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    AgentTunnel t = (AgentTunnel)o;
                    if (t.isBound()) {
                        session.unbindAgentTunnel(t.getNodeId());
                    }
                    ++n2;
                }
                final List tunnels2 = session.getAgentTunnels();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        TunnelManager.this.viewer.setInput((Object)tunnels2);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot unbind tunnel";
            }
        }.start();
    }
}

