/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.ArchiveLockManager;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.IArchiveLockManager;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAFolderInputStream;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.i18n.CoreMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderArchiveReader
implements IDocArchiveReader {
    static Logger logger = Logger.getLogger(FolderArchiveReader.class.getName());
    private String folderName;
    private HashSet<RAFolderInputStream> inputStreams = new HashSet();

    public FolderArchiveReader(String folderName) throws IOException {
        if (folderName == null || folderName.length() == 0) {
            throw new IllegalArgumentException(folderName);
        }
        File fd = new File(folderName);
        if (!fd.exists() || !fd.isDirectory()) {
            throw new FileNotFoundException(CoreMessages.getFormattedString("error.InvalidArchiveName", folderName));
        }
        this.folderName = fd.getCanonicalPath();
    }

    @Override
    public String getName() {
        return this.folderName;
    }

    @Override
    public void open() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        IOException exception = null;
        HashSet<RAFolderInputStream> hashSet = this.inputStreams;
        synchronized (hashSet) {
            ArrayList<RAFolderInputStream> inputs = new ArrayList<RAFolderInputStream>(this.inputStreams);
            for (RAFolderInputStream in : inputs) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    if (exception != null) {
                        exception = ex;
                    }
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    @Override
    public RAInputStream getStream(String relativePath) throws IOException {
        String path = ArchiveUtil.generateFullPath(this.folderName, relativePath);
        File file = new File(path);
        if (file.exists()) {
            return new RAFolderInputStream(this.inputStreams, file);
        }
        throw new FileNotFoundException(relativePath);
    }

    @Override
    public RAInputStream getInputStream(String relativePath) throws IOException {
        return this.getStream(relativePath);
    }

    @Override
    public boolean exists(String relativePath) {
        String fullPath = ArchiveUtil.generateFullPath(this.folderName, relativePath);
        File fd = new File(fullPath);
        return fd.exists();
    }

    @Override
    public List<String> listStreams(String relativeStoragePath) throws IOException {
        File[] files;
        ArrayList<String> streamList = new ArrayList<String>();
        String storagePath = ArchiveUtil.generateFullPath(this.folderName, relativeStoragePath);
        File dir = new File(storagePath);
        if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                String relativePath;
                File file = files[i];
                if (file.isFile() && !ArchiveUtil.needSkip(relativePath = ArchiveUtil.generateRelativePath(this.folderName, file.getPath()))) {
                    streamList.add(relativePath);
                }
                ++i;
            }
        }
        return streamList;
    }

    @Override
    public List<String> listAllStreams() throws IOException {
        ArrayList list = new ArrayList();
        ArchiveUtil.listAllFiles(new File(this.folderName), list);
        ArrayList<String> streams = new ArrayList<String>();
        int i = 0;
        while (i < list.size()) {
            File file = (File)list.get(i);
            String relativePath = ArchiveUtil.generateRelativePath(this.folderName, file.getPath());
            if (!ArchiveUtil.needSkip(relativePath)) {
                streams.add(relativePath);
            }
            ++i;
        }
        return streams;
    }

    @Override
    public Object lock(String stream) throws IOException {
        String path = ArchiveUtil.generateFullPath(this.folderName, String.valueOf(stream) + ".lck");
        IArchiveLockManager lockManager = ArchiveLockManager.getInstance();
        return lockManager.lock(path);
    }

    @Override
    public void unlock(Object lock) {
        IArchiveLockManager lockManager = ArchiveLockManager.getInstance();
        lockManager.unlock(lock);
    }
}

