/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.widgets;

import java.text.DecimalFormat;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.constants.Severity;
import org.netxms.ui.eclipse.charts.Messages;
import org.netxms.ui.eclipse.charts.api.GaugeColorMode;
import org.netxms.ui.eclipse.charts.widgets.GaugeWidget;
import org.netxms.ui.eclipse.charts.widgets.internal.DataComparisonElement;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class BarGaugeWidget
extends GaugeWidget {
    private static final int MAX_BAR_THICKNESS = 40;
    private static final int SCALE_TEXT_HEIGHT = 16;
    private static final int SCALE_TEXT_WIDTH = 20;
    private Font[] scaleFonts = null;

    public BarGaugeWidget(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void createFonts() {
        this.scaleFonts = new Font[16];
        int i = 0;
        while (i < this.scaleFonts.length) {
            this.scaleFonts[i] = new Font((Device)this.getDisplay(), this.fontName, i + 6, 0);
            ++i;
        }
    }

    @Override
    protected void disposeFonts() {
        if (this.scaleFonts != null) {
            int i = 0;
            while (i < this.scaleFonts.length) {
                this.scaleFonts[i].dispose();
                ++i;
            }
        }
    }

    @Override
    protected void renderElement(GC gc, DataComparisonElement dci, int x, int y, int w, int h) {
        double pointValue;
        Rectangle rect = new Rectangle(x + 5, y + 5, w - 10, h - 10);
        gc.setAntialias(1);
        if (this.elementBordersVisible) {
            gc.setForeground(this.getColorFromPreferences("Chart.Axis.Y.Color"));
            gc.drawRectangle(rect);
            rect.x += 5;
            rect.y += 5;
            rect.width -= 10;
            rect.height -= 10;
        }
        if (this.legendVisible) {
            gc.setForeground(this.getColorFromPreferences("Chart.Colors.Legend"));
            gc.setFont(null);
            Point legendExt = gc.textExtent(dci.getName());
            switch (this.legendPosition) {
                case 4: {
                    gc.drawText(dci.getName(), rect.x + (rect.width - legendExt.x) / 2, rect.y + 4, true);
                    rect.y += legendExt.y + 8;
                    rect.height -= legendExt.y + 8;
                    break;
                }
                case 8: {
                    rect.height -= legendExt.y + 8;
                    gc.drawText(dci.getName(), rect.x + (rect.width - legendExt.x) / 2, rect.y + rect.height + 4, true);
                    break;
                }
                case 1: {
                    gc.drawText(dci.getName(), rect.x + 4, rect.y + (rect.height - legendExt.y) / 2, true);
                    rect.x += legendExt.x + 8;
                    rect.width -= legendExt.x + 8;
                    break;
                }
                case 2: {
                    rect.width -= legendExt.x + 8;
                    gc.drawText(dci.getName(), rect.x + rect.width + 4, rect.y + (rect.height - legendExt.y) / 2, true);
                }
            }
        }
        if (this.isVertical()) {
            if (rect.height > 40) {
                int d = rect.height - 40;
                rect.height -= d;
                rect.y += d / 2;
            }
            rect.y -= 8;
        } else {
            if (rect.width > 40) {
                int d = rect.width - 40;
                rect.width -= d;
                rect.x += d / 2;
            }
            rect.x -= 10;
        }
        gc.setBackground(this.getColorFromPreferences("Chart.Colors.PlotArea"));
        gc.setForeground(this.getColorFromPreferences("Chart.Colors.DialScale"));
        gc.fillRectangle(rect);
        gc.drawRectangle(rect);
        rect.x += 2;
        rect.y += 2;
        rect.width -= 3;
        rect.height -= 3;
        double d = pointValue = this.isVertical() ? (this.maxValue - this.minValue) / (double)rect.width : (this.maxValue - this.minValue) / (double)rect.height;
        if (dci.getValue() > this.minValue) {
            if (this.colorMode == GaugeColorMode.ZONE) {
                double right = this.minValue;
                if (this.leftRedZone > this.minValue) {
                    right = this.leftRedZone + (this.leftYellowZone - this.leftRedZone) / 2.0;
                    this.drawZone(gc, rect, this.minValue, right, pointValue, RED_ZONE_COLOR, YELLOW_ZONE_COLOR);
                }
                double left = right;
                right = this.leftYellowZone + (this.rightYellowZone - this.leftYellowZone) / 2.0;
                this.drawZone(gc, rect, left, right, pointValue, this.leftYellowZone > this.minValue ? YELLOW_ZONE_COLOR : GREEN_ZONE_COLOR, GREEN_ZONE_COLOR);
                left = right;
                right = this.rightYellowZone + (this.rightRedZone - this.rightYellowZone) / 2.0;
                if (this.rightYellowZone < this.rightRedZone) {
                    this.drawZone(gc, rect, left, right, pointValue, GREEN_ZONE_COLOR, YELLOW_ZONE_COLOR);
                    left = right;
                    this.drawZone(gc, rect, left, this.maxValue, pointValue, YELLOW_ZONE_COLOR, this.rightRedZone < this.maxValue ? RED_ZONE_COLOR : YELLOW_ZONE_COLOR);
                } else if (this.rightRedZone < this.maxValue) {
                    this.drawZone(gc, rect, left, right, pointValue, GREEN_ZONE_COLOR, RED_ZONE_COLOR);
                }
                double v = dci.getValue();
                if (v < this.maxValue) {
                    gc.setBackground(this.getColorFromPreferences("Chart.Colors.PlotArea"));
                    if (this.isVertical()) {
                        int points = (int)((v - this.minValue) / pointValue);
                        gc.fillRectangle(rect.x + points, rect.y, rect.width - points, rect.height);
                    } else {
                        int points = (int)((this.maxValue - v) / pointValue);
                        gc.fillRectangle(rect.x, rect.y, rect.width, points);
                    }
                }
            } else {
                if (this.colorMode == GaugeColorMode.THRESHOLD) {
                    gc.setBackground(StatusDisplayInfo.getStatusColor((Severity)dci.getActiveThresholdSeverity()));
                } else {
                    gc.setBackground(this.colors.create(this.customColor));
                }
                int points = (int)((dci.getValue() - this.minValue) / pointValue);
                if (this.isVertical()) {
                    if (points > rect.width) {
                        points = rect.width;
                    }
                    gc.fillRectangle(rect.x, rect.y, points, rect.height);
                } else {
                    if (points > rect.height) {
                        points = rect.height;
                    }
                    gc.fillRectangle(rect.x, rect.y + rect.height - points, rect.width, points);
                }
            }
        }
        this.drawScale(gc, rect, pointValue);
    }

    private void drawZone(GC gc, Rectangle rect, double startValue, double endValue, double pointValue, RGB startColor, RGB endColor) {
        int start = (int)((startValue - this.minValue) / pointValue);
        int points = (int)((endValue - startValue) / pointValue) + 1;
        if (this.isVertical()) {
            gc.setForeground(this.colors.create(startColor));
            gc.setBackground(this.colors.create(endColor));
            gc.fillGradientRectangle(rect.x + start, rect.y, points, rect.height, false);
        } else {
            gc.setBackground(this.colors.create(startColor));
            gc.setForeground(this.colors.create(endColor));
            int y = rect.y + rect.height - start - points + 1;
            if (y + points >= rect.y + rect.height) {
                --points;
            }
            gc.fillGradientRectangle(rect.x, y, rect.width, points, true);
        }
    }

    private void drawScale(GC gc, Rectangle rect, double pointValue) {
        Color scaleColor = this.getColorFromPreferences("Chart.Colors.DialScale");
        Color scaleTextColor = this.getColorFromPreferences("Chart.Colors.DialScaleText");
        Font markFont = WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.scaleFonts, (String)"900MM", (int)20, (int)16);
        gc.setFont(markFont);
        double step = BarGaugeWidget.getStepMagnitude(Math.max(Math.abs(this.minValue), Math.abs(this.maxValue)));
        double value = this.minValue;
        float pointsStep = (float)(step / pointValue);
        if (this.isVertical()) {
            float x = 0.0f;
            while (x < (float)rect.width) {
                if (this.gridVisible && x > 0.0f) {
                    gc.setForeground(scaleColor);
                    gc.drawLine(rect.x + (int)x, rect.y - 2, rect.x + (int)x, rect.y + rect.height + 1);
                }
                String text = BarGaugeWidget.roundedMarkValue(value, step);
                gc.setForeground(scaleTextColor);
                gc.drawText(text, rect.x + (int)x, rect.y + rect.height + 4, 1);
                x += pointsStep;
                value += step;
            }
        } else {
            int textHeight = gc.textExtent((String)"999MM").y;
            float y = rect.height;
            while (y > 0.0f) {
                if (this.gridVisible && y < (float)rect.height) {
                    gc.setForeground(scaleColor);
                    gc.drawLine(rect.x - 2, rect.y + (int)y, rect.x + rect.width + 1, rect.y + (int)y);
                }
                String text = BarGaugeWidget.roundedMarkValue(value, step);
                gc.setForeground(scaleTextColor);
                gc.drawText(text, rect.x + rect.width + 4, rect.y + (int)y - textHeight * 3 / 4, 1);
                y -= pointsStep;
                value += step;
            }
        }
    }

    private static double getStepMagnitude(double maxValue) {
        double d = 1.0E-5;
        while (d < 1.0E19) {
            if (maxValue > d && maxValue <= d * 10.0) break;
            d *= 10.0;
        }
        return d;
    }

    private static String roundedMarkValue(double value, double step) {
        double absValue = Math.abs(value);
        if (absValue >= 1.0E10) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Long.toString(Math.round(value / 1.0E9))));
            Messages.get();
            return stringBuilder.append(Messages.DialChartWidget_G).toString();
        }
        if (absValue >= 1.0E9) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(new DecimalFormat("#.#").format(value / 1.0E9)));
            Messages.get();
            return stringBuilder.append(Messages.DialChartWidget_G).toString();
        }
        if (absValue >= 1.0E7) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Long.toString(Math.round(value / 1000000.0))));
            Messages.get();
            return stringBuilder.append(Messages.DialChartWidget_M).toString();
        }
        if (absValue >= 1000000.0) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(new DecimalFormat("#.#").format(value / 1000000.0)));
            Messages.get();
            return stringBuilder.append(Messages.DialChartWidget_M).toString();
        }
        if (absValue >= 10000.0) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Long.toString(Math.round(value / 1000.0))));
            Messages.get();
            return stringBuilder.append(Messages.DialChartWidget_K).toString();
        }
        if (absValue >= 1000.0) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(new DecimalFormat("#.#").format(value / 1000.0)));
            Messages.get();
            return stringBuilder.append(Messages.DialChartWidget_K).toString();
        }
        if (absValue >= 1.0 && step >= 1.0) {
            return Long.toString(Math.round(value));
        }
        if (absValue == 0.0) {
            return "0";
        }
        if (step < 1.0E-5) {
            return Double.toString(value);
        }
        if (step < 1.0E-4) {
            return new DecimalFormat("#.#####").format(value);
        }
        if (step < 0.001) {
            return new DecimalFormat("#.####").format(value);
        }
        if (step < 0.01) {
            return new DecimalFormat("#.###").format(value);
        }
        return new DecimalFormat("#.##").format(value);
    }
}

