/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.ChartFactory;
import org.netxms.ui.eclipse.charts.api.Gauge;
import org.netxms.ui.eclipse.charts.api.GaugeColorMode;
import org.netxms.ui.eclipse.dashboard.widgets.ComparisonChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.internal.GaugeConfig;
import org.netxms.ui.eclipse.tools.ColorConverter;

public class GaugeElement
extends ComparisonChartElement {
    private GaugeConfig config;

    public GaugeElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = GaugeConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new GaugeConfig();
        }
        this.refreshInterval = this.config.getRefreshRate();
        switch (this.config.getGaugeType()) {
            case 1: {
                this.chart = ChartFactory.createBarGaugeChart((Composite)this, (int)0);
                break;
            }
            case 2: {
                this.chart = ChartFactory.createCurrentValueChart((Composite)this, (int)0);
                break;
            }
            default: {
                this.chart = ChartFactory.createDialChart((Composite)this, (int)0);
            }
        }
        this.chart.setChartTitle(this.config.getTitle());
        this.chart.setTitleVisible(this.config.isShowTitle());
        this.chart.setLegendVisible(this.config.isShowLegend());
        this.chart.setLegendPosition(this.config.getLegendPosition());
        ((Gauge)this.chart).setLegendInside(this.config.isLegendInside());
        ((Gauge)this.chart).setVertical(this.config.isVertical());
        ((Gauge)this.chart).setElementBordersVisible(this.config.isElementBordersVisible());
        ((Gauge)this.chart).setMinValue(this.config.getMinValue());
        ((Gauge)this.chart).setMaxValue(this.config.getMaxValue());
        ((Gauge)this.chart).setLeftYellowZone(this.config.getLeftYellowZone());
        ((Gauge)this.chart).setLeftRedZone(this.config.getLeftRedZone());
        ((Gauge)this.chart).setRightYellowZone(this.config.getRightYellowZone());
        ((Gauge)this.chart).setRightRedZone(this.config.getRightRedZone());
        ((Gauge)this.chart).setFontName(this.config.getFontName());
        ((Gauge)this.chart).setColorMode(GaugeColorMode.getByValue((int)this.config.getColorMode()));
        ((Gauge)this.chart).setCustomColor(ColorConverter.rgbFromInt((int)this.config.getCustomColor()));
        int index = 0;
        ChartDciConfig[] chartDciConfigArray = this.config.getDciList();
        int n = chartDciConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChartDciConfig dci = chartDciConfigArray[n2];
            this.chart.addParameter(new GraphItem(dci.nodeId, dci.dciId, 0, 0, Long.toString(dci.dciId), dci.getName(), dci.getDisplayFormat()), 0.0);
            int color = dci.getColorAsInt();
            if (color != -1) {
                this.chart.setPaletteEntry(index, new ChartColor(color));
            }
            ++index;
            ++n2;
        }
        this.chart.initializationComplete();
        this.startRefreshTimer();
    }

    @Override
    protected ChartDciConfig[] getDciList() {
        return this.config.getDciList();
    }
}

