/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.NetworkMap;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class MapSeedNodes
extends PropertyPage {
    public static final int COLUMN_NAME = 0;
    private AbstractObject object = null;
    private TableViewer viewer;
    private Button addButton;
    private Button deleteButton;
    private Set<AbstractObject> seedNodes;
    private boolean isModified = false;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (AbstractObject)this.getElement().getAdapter(AbstractObject.class);
        if (this.object == null || !(this.object instanceof NetworkMap)) {
            return dialogArea;
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.viewer = new TableViewer(dialogArea, 2048);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((AbstractObject)element).getObjectName();
            }
        });
        NXCSession session = ConsoleSharedData.getSession();
        this.seedNodes = new HashSet<AbstractObject>(session.findMultipleObjects(((NetworkMap)this.object).getSeedObjectIds(), false));
        this.viewer.setInput(this.seedNodes);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gridData);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText("Add...");
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List selected;
                ObjectSelectionDialog dlg = new ObjectSelectionDialog(MapSeedNodes.this.getShell(), null, ObjectSelectionDialog.createNodeSelectionFilter((boolean)false));
                dlg.enableMultiSelection(true);
                if (dlg.open() == 0 && (selected = dlg.getSelectedObjects()).size() > 0) {
                    MapSeedNodes.this.seedNodes.addAll(selected);
                    MapSeedNodes.this.viewer.setInput((Object)MapSeedNodes.this.seedNodes);
                    MapSeedNodes.this.isModified = true;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText("Delete");
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)MapSeedNodes.this.viewer.getSelection();
                if (selection.size() > 0) {
                    MapSeedNodes.this.seedNodes.removeAll(selection.toList());
                    MapSeedNodes.this.viewer.setInput((Object)MapSeedNodes.this.seedNodes);
                    MapSeedNodes.this.isModified = true;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        if (!this.isModified) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        ArrayList<Long> seedObjectIds = new ArrayList<Long>();
        for (AbstractObject o : this.seedNodes) {
            seedObjectIds.add(o.getObjectId());
        }
        md.setSeedObjectIds(seedObjectIds);
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Update network map seed nodes", null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
                MapSeedNodes.this.isModified = false;
            }

            protected String getErrorMessage() {
                return "Network map seed node update failed";
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            MapSeedNodes.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }
}

