/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import java.util.List;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.configs.SingleDciConfig;
import org.netxms.client.maps.elements.NetworkMapObject;

public class LinkEditor {
    private NetworkMapLink link;
    private NetworkMapPage mapPage;
    private String name;
    private int type;
    private String connectorName1;
    private String connectorName2;
    private int color;
    private List<Long> statusObject;
    private int routingAlgorithm;
    private boolean modified = false;
    private List<SingleDciConfig> dciList;

    public LinkEditor(NetworkMapLink link, NetworkMapPage mapPage) {
        this.link = link;
        this.mapPage = mapPage;
        this.name = link.getName();
        this.type = link.getType();
        this.connectorName1 = link.getConnectorName1();
        this.connectorName2 = link.getConnectorName2();
        this.color = link.getColor();
        this.statusObject = link.getStatusObject();
        this.routingAlgorithm = link.getRouting();
        this.dciList = link.getDciAsList();
    }

    public void update() {
        this.mapPage.removeLink(this.link);
        long[] bp = this.link.getBendPoints();
        this.link = new NetworkMapLink(this.name, this.type, this.link.getElement1(), this.link.getElement2(), this.connectorName1, this.connectorName2, this.dciList.toArray(new SingleDciConfig[this.dciList.size()]), this.link.getFlags());
        this.link.setColor(this.color);
        this.link.setStatusObject(this.statusObject);
        this.link.setRouting(this.routingAlgorithm);
        this.link.setBendPoints(bp);
        this.mapPage.addLink(this.link);
        this.modified = true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getConnectorName1() {
        return this.connectorName1;
    }

    public void setConnectorName1(String connectorName1) {
        this.connectorName1 = connectorName1;
    }

    public String getConnectorName2() {
        return this.connectorName2;
    }

    public void setConnectorName2(String connectorName2) {
        this.connectorName2 = connectorName2;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public List<Long> getStatusObject() {
        return this.statusObject;
    }

    public void setStatusObject(List<Long> statusObject) {
        this.statusObject = statusObject;
    }

    public void addStatusObject(Long id) {
        this.statusObject.add(id);
    }

    public void removeStatusObjectByIndex(int index) {
        this.statusObject.remove(index);
    }

    public int getRoutingAlgorithm() {
        return this.routingAlgorithm;
    }

    public void setRoutingAlgorithm(int routingAlgorithm) {
        this.routingAlgorithm = routingAlgorithm;
    }

    public NetworkMapPage getMapPage() {
        return this.mapPage;
    }

    public long getObject1() {
        NetworkMapObject e = (NetworkMapObject)this.mapPage.getElement(this.link.getElement1(), NetworkMapObject.class);
        return e != null ? e.getObjectId() : 0L;
    }

    public long getObject2() {
        NetworkMapObject e = (NetworkMapObject)this.mapPage.getElement(this.link.getElement2(), NetworkMapObject.class);
        return e != null ? e.getObjectId() : 0L;
    }

    public boolean isModified() {
        return this.modified;
    }

    public List<SingleDciConfig> getDciList() {
        return this.dciList;
    }

    public void setDciList(List<SingleDciConfig> dciList) {
        this.dciList = dciList;
    }
}

