/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.epp.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.ServerAction;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.events.AlarmCategory;
import org.netxms.client.events.EventProcessingPolicy;
import org.netxms.client.events.EventProcessingPolicyRule;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.epp.Activator;
import org.netxms.ui.eclipse.epp.Messages;
import org.netxms.ui.eclipse.epp.views.helpers.RuleClipboard;
import org.netxms.ui.eclipse.epp.widgets.RuleEditor;
import org.netxms.ui.eclipse.epp.widgets.helpers.ImageFactory;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.FilterText;

public class EventProcessingPolicyEditor
extends ViewPart
implements ISaveablePart {
    public static final String ID = "org.netxms.ui.eclipse.epp.view.policy_editor";
    public static final String JOB_FAMILY = "PolicyEditorJob";
    private static final Color BACKGROUND_COLOR = new Color((Device)Display.getCurrent(), 255, 255, 255);
    private NXCSession session;
    private boolean policyLocked = false;
    private EventProcessingPolicy policy;
    private SessionListener sessionListener;
    private Map<Long, ServerAction> actions = new HashMap<Long, ServerAction>();
    private FilterText filterControl;
    private String filterText = null;
    private ScrolledComposite scroller;
    private Composite dataArea;
    private List<RuleEditor> ruleEditors = new ArrayList<RuleEditor>();
    private boolean verticalLayout = false;
    private boolean filterEnabled = true;
    private boolean modified = false;
    private Set<RuleEditor> selection;
    private int lastSelectedRule = -1;
    private RuleClipboard clipboard = new RuleClipboard();
    private Font normalFont;
    private Font boldFont;
    private Image imageAlarm;
    private Image imageSituation;
    private Image imageExecute;
    private Image imageTerminate;
    private Image imageStop;
    private Image imageCollapse;
    private Image imageExpand;
    private Image imageEdit;
    private Action actionHorizontal;
    private Action actionVertical;
    private Action actionSave;
    private Action actionCollapseAll;
    private Action actionExpandAll;
    private Action actionInsertBefore;
    private Action actionInsertAfter;
    private Action actionCut;
    private Action actionCopy;
    private Action actionPaste;
    private Action actionDelete;
    private Action actionEnableRule;
    private Action actionDisableRule;
    private Action actionShowFilter;
    private Action actionAddRule;

    public void createPartControl(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.filterEnabled = settings.getBoolean("EventProcessingPolicyEditor.filterEnabled");
        try {
            Platform.getAdapterManager().loadAdapter((Object)new EventTemplate(0L), "org.eclipse.ui.model.IWorkbenchAdapter");
            Platform.getAdapterManager().loadAdapter((Object)new ServerAction(0L), "org.eclipse.ui.model.IWorkbenchAdapter");
            Platform.getAdapterManager().loadAdapter((Object)this.session.getTopLevelObjects()[0], "org.eclipse.ui.model.IWorkbenchAdapter");
        }
        catch (Exception exception) {}
        this.imageStop = Activator.getImageDescriptor("icons/stop.png").createImage();
        this.imageAlarm = Activator.getImageDescriptor("icons/alarm.png").createImage();
        this.imageSituation = Activator.getImageDescriptor("icons/situation.gif").createImage();
        this.imageExecute = Activator.getImageDescriptor("icons/execute.png").createImage();
        this.imageTerminate = Activator.getImageDescriptor("icons/terminate.png").createImage();
        this.imageCollapse = SharedIcons.COLLAPSE.createImage();
        this.imageExpand = SharedIcons.EXPAND.createImage();
        this.imageEdit = SharedIcons.EDIT.createImage();
        parent.setLayout((Layout)new FormLayout());
        this.filterControl = new FilterText(parent, 0);
        this.filterControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EventProcessingPolicyEditor.this.onFilterModify();
            }
        });
        this.filterControl.setCloseAction(new Action(){

            public void run() {
                EventProcessingPolicyEditor.this.enableFilter(false);
            }
        });
        this.scroller = new ScrolledComposite(parent, 512);
        this.dataArea = new Composite((Composite)this.scroller, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.dataArea.setLayout((Layout)layout);
        this.dataArea.setBackground(BACKGROUND_COLOR);
        this.scroller.setContent((Control)this.dataArea);
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        this.scroller.getVerticalBar().setIncrement(20);
        this.scroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = EventProcessingPolicyEditor.this.scroller.getClientArea();
                EventProcessingPolicyEditor.this.scroller.setMinSize(EventProcessingPolicyEditor.this.dataArea.computeSize(r.width, -1));
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterControl);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.scroller.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterControl.setLayoutData((Object)fd);
        if (Platform.getOS().equals("win32")) {
            this.normalFont = new Font((Device)parent.getDisplay(), "Verdana", 8, 0);
            this.boldFont = new Font((Device)parent.getDisplay(), "Verdana", 8, 1);
        } else {
            this.normalFont = JFaceResources.getDefaultFont();
            this.boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        }
        this.sessionListener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                EventProcessingPolicyEditor.this.processSessionNotification(n);
            }
        };
        this.session.addListener(this.sessionListener);
        this.selection = new TreeSet<RuleEditor>(new Comparator<RuleEditor>(){

            @Override
            public int compare(RuleEditor arg0, RuleEditor arg1) {
                return arg0.getRuleNumber() - arg1.getRuleNumber();
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.openEventProcessingPolicy();
        this.activateContext();
        if (this.filterEnabled) {
            this.filterControl.setFocus();
        } else {
            this.enableFilter(false);
        }
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.epp.context.PolicyEditor");
        }
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        Messages.get();
        this.actionHorizontal = new Action(Messages.EventProcessingPolicyEditor_LayoutH, 8){

            public void run() {
                EventProcessingPolicyEditor.this.verticalLayout = false;
                EventProcessingPolicyEditor.this.updateLayout();
            }
        };
        this.actionHorizontal.setChecked(!this.verticalLayout);
        this.actionHorizontal.setImageDescriptor(Activator.getImageDescriptor("icons/h_layout.gif"));
        Messages.get();
        this.actionVertical = new Action(Messages.EventProcessingPolicyEditor_LayoutV, 8){

            public void run() {
                EventProcessingPolicyEditor.this.verticalLayout = true;
                EventProcessingPolicyEditor.this.updateLayout();
            }
        };
        this.actionVertical.setChecked(this.verticalLayout);
        this.actionVertical.setImageDescriptor(Activator.getImageDescriptor("icons/v_layout.gif"));
        Messages.get();
        this.actionSave = new Action(Messages.EventProcessingPolicyEditor_Save){

            public void run() {
                EventProcessingPolicyEditor.this.savePolicy();
            }
        };
        this.actionSave.setImageDescriptor(SharedIcons.SAVE);
        this.actionSave.setEnabled(false);
        Messages.get();
        this.actionCollapseAll = new Action(Messages.EventProcessingPolicyEditor_CollapseAll){

            public void run() {
                EventProcessingPolicyEditor.this.setAllRulesCollapsed(true);
            }
        };
        this.actionCollapseAll.setImageDescriptor(SharedIcons.COLLAPSE_ALL);
        Messages.get();
        this.actionExpandAll = new Action(Messages.EventProcessingPolicyEditor_ExpandAll){

            public void run() {
                EventProcessingPolicyEditor.this.setAllRulesCollapsed(false);
            }
        };
        this.actionExpandAll.setImageDescriptor(SharedIcons.EXPAND_ALL);
        Messages.get();
        this.actionDelete = new Action(Messages.EventProcessingPolicyEditor_Delete){

            public void run() {
                EventProcessingPolicyEditor.this.deleteSelectedRules();
            }
        };
        this.actionDelete.setImageDescriptor(SharedIcons.DELETE_OBJECT);
        this.actionDelete.setEnabled(false);
        Messages.get();
        this.actionInsertBefore = new Action(Messages.EventProcessingPolicyEditor_InsertBefore){

            public void run() {
                EventProcessingPolicyEditor.this.insertRule(EventProcessingPolicyEditor.this.lastSelectedRule - 1);
            }
        };
        Messages.get();
        this.actionInsertAfter = new Action(Messages.EventProcessingPolicyEditor_InsertAfter){

            public void run() {
                EventProcessingPolicyEditor.this.insertRule(EventProcessingPolicyEditor.this.lastSelectedRule);
            }
        };
        Messages.get();
        this.actionCut = new Action(Messages.EventProcessingPolicyEditor_Cut){

            public void run() {
                EventProcessingPolicyEditor.this.cutRules();
            }
        };
        this.actionCut.setImageDescriptor(SharedIcons.CUT);
        this.actionCut.setEnabled(false);
        Messages.get();
        this.actionCopy = new Action(Messages.EventProcessingPolicyEditor_Copy){

            public void run() {
                EventProcessingPolicyEditor.this.copyRules();
            }
        };
        this.actionCopy.setImageDescriptor(SharedIcons.COPY);
        this.actionCopy.setEnabled(false);
        Messages.get();
        this.actionPaste = new Action(Messages.EventProcessingPolicyEditor_Paste){

            public void run() {
                EventProcessingPolicyEditor.this.pasteRules();
            }
        };
        this.actionPaste.setImageDescriptor(SharedIcons.PASTE);
        this.actionPaste.setEnabled(false);
        Messages.get();
        this.actionEnableRule = new Action(Messages.EventProcessingPolicyEditor_Enable){

            public void run() {
                EventProcessingPolicyEditor.this.enableRules(true);
            }
        };
        Messages.get();
        this.actionDisableRule = new Action(Messages.EventProcessingPolicyEditor_Disable){

            public void run() {
                EventProcessingPolicyEditor.this.enableRules(false);
            }
        };
        Messages.get();
        this.actionShowFilter = new Action(Messages.EventProcessingPolicyEditor_ShowFilter, 2){

            public void run() {
                EventProcessingPolicyEditor.this.enableFilter(EventProcessingPolicyEditor.this.actionShowFilter.isChecked());
            }
        };
        this.actionAddRule = new Action("&Add new rule"){

            public void run() {
                EventProcessingPolicyEditor.this.insertRule(EventProcessingPolicyEditor.this.ruleEditors.size());
            }
        };
        this.actionAddRule.setImageDescriptor(SharedIcons.ADD_OBJECT);
        this.actionShowFilter.setChecked(this.filterEnabled);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.epp.commands.show_rule_filter");
        ActionHandler showFilterHandler = new ActionHandler((IAction)this.actionShowFilter);
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)showFilterHandler);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionExpandAll);
        manager.add((IAction)this.actionCollapseAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHorizontal);
        manager.add((IAction)this.actionVertical);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowFilter);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionAddRule);
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionExpandAll);
        manager.add((IAction)this.actionCollapseAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHorizontal);
        manager.add((IAction)this.actionVertical);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCut);
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionPaste);
        manager.add((IAction)this.actionDelete);
    }

    private void openEventProcessingPolicy() {
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.EventProcessingPolicyEditor_OpenJob_Title, (IWorkbenchPart)this, "org.netxms.ui.eclipse.epp", JOB_FAMILY){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.EventProcessingPolicyEditor_OpenJob_Error;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void runInternal(IProgressMonitor monitor) throws Exception {
                List actions = EventProcessingPolicyEditor.this.session.getActions();
                Map map = EventProcessingPolicyEditor.this.actions;
                synchronized (map) {
                    for (ServerAction a : actions) {
                        EventProcessingPolicyEditor.this.actions.put(a.getId(), a);
                    }
                }
                EventProcessingPolicyEditor.this.policy = EventProcessingPolicyEditor.this.session.openEventProcessingPolicy();
                EventProcessingPolicyEditor.this.policyLocked = true;
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        EventProcessingPolicyEditor.this.initPolicyEditor();
                        if (EventProcessingPolicyEditor.this.filterEnabled) {
                            EventProcessingPolicyEditor.this.filterControl.setFocus();
                        }
                    }
                });
            }

            protected void jobFailureHandler() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        EventProcessingPolicyEditor.this.getViewSite().getPage().hideView((IViewPart)EventProcessingPolicyEditor.this);
                    }
                });
            }
        };
        job.start();
    }

    private void initPolicyEditor() {
        int ruleNumber = 1;
        for (EventProcessingPolicyRule rule : this.policy.getRules()) {
            if (this.isRuleVisible(rule)) {
                RuleEditor editor = new RuleEditor(this.dataArea, rule, ruleNumber++, this);
                editor.setDragDetect(true);
                this.ruleEditors.add(editor);
                GridData gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                editor.setLayoutData(gd);
                continue;
            }
            ++ruleNumber;
        }
        this.dataArea.layout();
        Rectangle r = this.scroller.getClientArea();
        this.scroller.setMinSize(this.dataArea.computeSize(r.width, -1));
    }

    private void updateLayout() {
        for (RuleEditor editor : this.ruleEditors) {
            if (editor.isDisposed()) continue;
            editor.setVerticalLayout(this.verticalLayout, false);
        }
        this.updateEditorAreaLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSessionNotification(SessionNotification n) {
        switch (n.getCode()) {
            case 1006: {
                Map<Long, ServerAction> map = this.actions;
                synchronized (map) {
                    this.actions.put(n.getSubCode(), (ServerAction)n.getObject());
                    break;
                }
            }
            case 1007: {
                Map<Long, ServerAction> map = this.actions;
                synchronized (map) {
                    this.actions.put(n.getSubCode(), (ServerAction)n.getObject());
                    break;
                }
            }
            case 1008: {
                Map<Long, ServerAction> map = this.actions;
                synchronized (map) {
                    this.actions.remove(n.getSubCode());
                    break;
                }
            }
        }
    }

    private void setAllRulesCollapsed(boolean collapsed) {
        for (RuleEditor editor : this.ruleEditors) {
            if (editor.isDisposed()) continue;
            editor.setCollapsed(collapsed, false);
        }
        this.updateEditorAreaLayout();
    }

    public void setFocus() {
        this.dataArea.setFocus();
    }

    private void savePolicy() {
        this.actionSave.setEnabled(false);
        Messages.get();
        new ConsoleJob(Messages.EventProcessingPolicyEditor_SaveJob_Title, (IWorkbenchPart)this, "org.netxms.ui.eclipse.epp", JOB_FAMILY){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                EventProcessingPolicyEditor.this.session.saveEventProcessingPolicy(EventProcessingPolicyEditor.this.policy);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        EventProcessingPolicyEditor.this.modified = false;
                        EventProcessingPolicyEditor.this.firePropertyChange(257);
                    }
                });
            }

            protected void jobFinalize() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        EventProcessingPolicyEditor.this.actionSave.setEnabled(EventProcessingPolicyEditor.this.modified);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.EventProcessingPolicyEditor_SaveJob_Error;
            }
        }.start();
    }

    public void dispose() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("EventProcessingPolicyEditor.filterEnabled", this.filterEnabled);
        if (this.sessionListener != null) {
            this.session.removeListener(this.sessionListener);
        }
        if (this.policyLocked) {
            Messages.get();
            new ConsoleJob(Messages.EventProcessingPolicyEditor_CloseJob_Title, null, "org.netxms.ui.eclipse.epp", JOB_FAMILY){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    EventProcessingPolicyEditor.this.session.closeEventProcessingPolicy();
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.EventProcessingPolicyEditor_CloseJob_Error;
                }
            }.start();
        }
        if (Platform.getOS().equals("win32")) {
            this.normalFont.dispose();
            this.boldFont.dispose();
        }
        this.imageStop.dispose();
        this.imageAlarm.dispose();
        this.imageExecute.dispose();
        this.imageTerminate.dispose();
        this.imageCollapse.dispose();
        this.imageExpand.dispose();
        this.imageEdit.dispose();
        super.dispose();
        ImageFactory.clearCache();
    }

    public void updateEditorAreaLayout() {
        this.dataArea.layout();
        Rectangle r = this.scroller.getClientArea();
        this.scroller.setMinSize(this.dataArea.computeSize(r.width, -1));
    }

    public ServerAction findActionById(Long id) {
        return this.actions.get(id);
    }

    public Map<Long, ServerAction> findServerActions(List<Long> idList) {
        HashMap<Long, ServerAction> resultSet = new HashMap<Long, ServerAction>();
        for (Long id : idList) {
            ServerAction action = this.actions.get(id);
            if (action == null) continue;
            resultSet.put(id, action);
        }
        return resultSet;
    }

    public Collection<ServerAction> getActions() {
        return this.actions.values();
    }

    public AlarmCategory findAlarmCategoryById(Long id) {
        NXCSession session = ConsoleSharedData.getSession();
        return session.findAlarmCategoryById(id.longValue());
    }

    public Font getNormalFont() {
        return this.normalFont;
    }

    public Font getBoldFont() {
        return this.boldFont;
    }

    public Image getImageAlarm() {
        return this.imageAlarm;
    }

    public Image getImageExecute() {
        return this.imageExecute;
    }

    public Image getImageTerminate() {
        return this.imageTerminate;
    }

    public Image getImageStop() {
        return this.imageStop;
    }

    public Image getImageCollapse() {
        return this.imageCollapse;
    }

    public Image getImageExpand() {
        return this.imageExpand;
    }

    public Image getImageEdit() {
        return this.imageEdit;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
        this.actionSave.setEnabled(modified);
        this.firePropertyChange(257);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.session.saveEventProcessingPolicy(this.policy);
        }
        catch (Exception e) {
            Shell shell = this.getViewSite().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.EventProcessingPolicyEditor_Error, (String)(String.valueOf(Messages.EventProcessingPolicyEditor_SaveError) + e.getMessage()));
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.modified;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }

    private void clearSelection() {
        for (RuleEditor e : this.selection) {
            e.setSelected(false);
        }
        this.selection.clear();
        this.lastSelectedRule = -1;
    }

    public void setSelection(RuleEditor e) {
        if (!e.isDragged()) {
            this.clearSelection();
        }
        this.addToSelection(e, false);
    }

    public void addToSelection(RuleEditor e, boolean allFromPrevSelection) {
        if (allFromPrevSelection && this.lastSelectedRule != -1) {
            int direction = Integer.signum(e.getRuleNumber() - this.lastSelectedRule);
            int i = this.lastSelectedRule + direction;
            while (i != e.getRuleNumber()) {
                RuleEditor r = this.ruleEditors.get(i - 1);
                this.selection.add(r);
                r.setSelected(true);
                i += direction;
            }
        }
        this.selection.add(e);
        e.setSelected(true);
        this.lastSelectedRule = e.getRuleNumber();
        this.onSelectionChange();
    }

    private void onSelectionChange() {
        this.actionDelete.setEnabled(this.selection.size() > 0);
        this.actionInsertBefore.setEnabled(this.selection.size() == 1);
        this.actionInsertAfter.setEnabled(this.selection.size() == 1);
        this.actionCut.setEnabled(this.selection.size() > 0);
        this.actionCopy.setEnabled(this.selection.size() > 0);
        this.actionPaste.setEnabled(this.selection.size() == 1 && !this.clipboard.isEmpty());
    }

    private void deleteSelectedRules() {
        for (RuleEditor e : this.selection) {
            this.policy.deleteRule(e.getRule());
            this.ruleEditors.remove((Object)e);
            e.dispose();
        }
        int i = 0;
        while (i < this.ruleEditors.size()) {
            this.ruleEditors.get(i).setRuleNumber(i + 1);
            ++i;
        }
        this.selection.clear();
        this.lastSelectedRule = -1;
        this.onSelectionChange();
        this.updateEditorAreaLayout();
        this.setModified(true);
    }

    private void insertRule(int position) {
        EventProcessingPolicyRule rule = new EventProcessingPolicyRule();
        this.policy.insertRule(rule, position);
        RuleEditor editor = new RuleEditor(this.dataArea, rule, position + 1, this);
        this.ruleEditors.add(position, editor);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        editor.setLayoutData(gd);
        int i = position + 1;
        while (i < this.ruleEditors.size()) {
            this.ruleEditors.get(i).setRuleNumber(i + 1);
            ++i;
        }
        if (position < this.ruleEditors.size() - 1) {
            RuleEditor anchor = null;
            int i2 = position + 1;
            while (i2 < this.ruleEditors.size()) {
                if (!this.ruleEditors.get(i2).isDisposed()) {
                    anchor = this.ruleEditors.get(i2);
                    break;
                }
                ++i2;
            }
            if (anchor != null) {
                editor.moveAbove((Control)anchor);
            }
        }
        this.updateEditorAreaLayout();
        this.setModified(true);
    }

    private void cutRules() {
        this.clipboard.clear();
        this.actionPaste.setEnabled(true);
        for (RuleEditor e : this.selection) {
            this.clipboard.add(e.getRule());
            this.policy.deleteRule(e.getRule());
            this.ruleEditors.remove((Object)e);
            e.dispose();
        }
        int i = 0;
        while (i < this.ruleEditors.size()) {
            this.ruleEditors.get(i).setRuleNumber(i + 1);
            ++i;
        }
        this.selection.clear();
        this.lastSelectedRule = -1;
        this.onSelectionChange();
        this.updateEditorAreaLayout();
        this.setModified(true);
    }

    private void copyRules() {
        this.clipboard.clear();
        this.actionPaste.setEnabled(true);
        for (RuleEditor e : this.selection) {
            this.clipboard.add(new EventProcessingPolicyRule(e.getRule()));
        }
    }

    private void pasteRules() {
        int position = this.lastSelectedRule;
        RuleEditor anchor = null;
        if (position < this.ruleEditors.size() - 1) {
            int i = position;
            while (i < this.ruleEditors.size()) {
                if (!this.ruleEditors.get(i).isDisposed()) {
                    anchor = this.ruleEditors.get(i);
                    break;
                }
                ++i;
            }
        }
        for (EventProcessingPolicyRule rule : this.clipboard.paste()) {
            this.policy.insertRule(rule, position);
            RuleEditor editor = new RuleEditor(this.dataArea, rule, position + 1, this);
            this.ruleEditors.add(position, editor);
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            editor.setLayoutData(gd);
            if (anchor != null) {
                editor.moveAbove((Control)anchor);
            }
            ++position;
        }
        int i = position;
        while (i < this.ruleEditors.size()) {
            this.ruleEditors.get(i).setRuleNumber(i + 1);
            ++i;
        }
        this.updateEditorAreaLayout();
        this.setModified(true);
    }

    public void moveSelection(RuleEditor anchor) {
        if (this.selection.contains((Object)anchor)) {
            for (RuleEditor s : this.selection) {
                s.setDragged(false);
            }
            return;
        }
        ArrayList<RuleEditor> movedRuleEditors = new ArrayList<RuleEditor>();
        for (RuleEditor e : this.ruleEditors) {
            if (this.selection.contains((Object)e)) continue;
            movedRuleEditors.add(e);
            if (!((Object)((Object)e)).equals((Object)anchor)) continue;
            RuleEditor curr = anchor;
            for (RuleEditor s : this.selection) {
                movedRuleEditors.add(s);
                s.moveBelow((Control)curr);
                curr = s;
                s.setDragged(false);
            }
        }
        this.policy = new EventProcessingPolicy(movedRuleEditors.size());
        int i = 0;
        for (RuleEditor e : movedRuleEditors) {
            this.policy.addRule(e.getRule());
            e.setRuleNumber(++i);
        }
        this.ruleEditors = movedRuleEditors;
        anchor.setDragged(false);
        this.updateEditorAreaLayout();
        this.setModified(true);
    }

    private void enableRules(boolean enabled) {
        for (RuleEditor e : this.selection) {
            e.enableRule(enabled);
        }
    }

    public void fillRuleContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionEnableRule);
        manager.add((IAction)this.actionDisableRule);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionInsertBefore);
        manager.add((IAction)this.actionInsertAfter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCut);
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionPaste);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionDelete);
    }

    public Image getImageSituation() {
        return this.imageSituation;
    }

    private void enableFilter(boolean enable) {
        this.filterEnabled = enable;
        this.filterControl.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.scroller.getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterControl) : new FormAttachment(0, 0);
        this.scroller.getParent().layout();
        if (enable) {
            this.filterControl.setFocus();
        } else {
            this.filterControl.setText("");
            this.onFilterModify();
        }
        this.actionShowFilter.setChecked(enable);
    }

    private void onFilterModify() {
        this.filterText = this.filterControl.getText().trim().toLowerCase();
        RuleEditor prev = null;
        int i = 0;
        while (i < this.ruleEditors.size()) {
            RuleEditor e = this.ruleEditors.get(i);
            boolean visible = this.isRuleVisible(e.getRule());
            if (!e.isDisposed() && !visible) {
                e.dispose();
                this.selection.remove((Object)e);
            } else if (e.isDisposed() && visible) {
                e = new RuleEditor(this.dataArea, e.getRule(), e.getRuleNumber(), this);
                GridData gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                e.setLayoutData(gd);
                if (prev != null) {
                    e.moveBelow((Control)prev);
                } else {
                    e.moveAbove(null);
                }
                this.ruleEditors.set(i, e);
            }
            if (!e.isDisposed()) {
                prev = e;
            }
            ++i;
        }
        this.updateEditorAreaLayout();
    }

    private boolean isRuleVisible(EventProcessingPolicyRule rule) {
        if (this.filterText == null || this.filterText.isEmpty()) {
            return true;
        }
        if (rule.getComments().toLowerCase().contains(this.filterText)) {
            return true;
        }
        for (Long code : rule.getEvents()) {
            EventTemplate evt = this.session.findEventTemplateByCode(code.longValue());
            if (evt == null || !evt.getName().toLowerCase().contains(this.filterText)) continue;
            return true;
        }
        for (Long id : rule.getSources()) {
            String name = this.session.getObjectName(id.longValue());
            if (name == null || !name.toLowerCase().contains(this.filterText)) continue;
            return true;
        }
        return false;
    }
}

