/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.RackOrientation;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.RackElement;

public class Chassis
extends DataCollectionTarget
implements RackElement {
    protected long controllerId;
    protected long rackId;
    protected UUID rackImage;
    protected short rackPosition;
    protected short rackHeight;
    protected RackOrientation rackOrientation;

    public Chassis(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.controllerId = msg.getFieldAsInt64(543L);
        this.rackId = msg.getFieldAsInt64(517L);
        this.rackImage = msg.getFieldAsUUID(518L);
        this.rackPosition = msg.getFieldAsInt16(519L);
        this.rackHeight = msg.getFieldAsInt16(520L);
        this.rackOrientation = RackOrientation.getByValue(msg.getFieldAsInt32(611L));
    }

    @Override
    public String getObjectClassName() {
        return "Chassis";
    }

    @Override
    public boolean isAlarmsVisible() {
        return true;
    }

    public long getControllerId() {
        return this.controllerId;
    }

    @Override
    public long getRackId() {
        return this.rackId;
    }

    @Override
    public UUID getRackImage() {
        return this.rackImage;
    }

    @Override
    public short getRackPosition() {
        return this.rackPosition;
    }

    @Override
    public short getRackHeight() {
        return this.rackHeight;
    }

    @Override
    public RackOrientation getRackOrientation() {
        return this.rackOrientation;
    }
}

