/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.xml.XalanXPathExecuter;
import org.apache.xpath.CachedXPathAPI;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XalanNsAwareXPathExecuter
extends XalanXPathExecuter {
    private CachedXPathAPI xpathAPI = new CachedXPathAPI();
    private XPathFactory xpathFact = XPathFactory.newInstance();
    private Map<String, String> xmlNamespaceMap;
    private Element namespaceElement;
    boolean detectXmlNamespaces;

    public Map<String, String> getXmlNamespaceMap() {
        return this.xmlNamespaceMap;
    }

    public void setXmlNamespaceMap(Map<String, String> xmlNamespaceMap) throws JRException {
        this.xmlNamespaceMap = xmlNamespaceMap;
    }

    public boolean getDetectXmlNamespaces() {
        return this.detectXmlNamespaces;
    }

    public void setDetectXmlNamespaces(boolean detectXmlNamespaces) {
        this.detectXmlNamespaces = detectXmlNamespaces;
    }

    protected void createNamespaceElement(Node contextNode, String expression) throws JRException {
        if (this.xmlNamespaceMap == null && this.detectXmlNamespaces && this.containsPrefixes(expression) && this.namespaceElement == null) {
            this.xmlNamespaceMap = this.extractXmlNamespaces(contextNode);
        }
        if (this.xmlNamespaceMap != null && this.xmlNamespaceMap.size() > 0 && this.namespaceElement == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = null;
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new JRException(e);
            }
            DOMImplementation impl = builder.getDOMImplementation();
            Set<String> nsSet = this.xmlNamespaceMap.keySet();
            Iterator<String> it = nsSet.iterator();
            String prefix = it.next();
            Document namespaceHolder = impl.createDocument(this.xmlNamespaceMap.get(prefix), prefix + ":namespaceMapping", null);
            this.namespaceElement = namespaceHolder.getDocumentElement();
            while (it.hasNext()) {
                prefix = it.next();
                this.namespaceElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, this.xmlNamespaceMap.get(prefix));
            }
        }
    }

    @Override
    public NodeList selectNodeList(Node contextNode, String expression) throws JRException {
        try {
            this.createNamespaceElement(contextNode, expression);
            if (this.namespaceElement != null) {
                return this.xpathAPI.selectNodeList(contextNode, expression, (Node)this.namespaceElement);
            }
            return this.xpathAPI.selectNodeList(contextNode, expression);
        }
        catch (TransformerException e) {
            throw new JRException("util.xml.xalan.xpath.selection.failure", new Object[]{expression}, e);
        }
    }

    @Override
    public Object selectObject(Node contextNode, String expression) throws JRException {
        try {
            Object value;
            this.createNamespaceElement(contextNode, expression);
            XObject object = null;
            object = this.namespaceElement != null ? this.xpathAPI.eval(contextNode, expression, (Node)this.namespaceElement) : this.xpathAPI.eval(contextNode, expression);
            switch (object.getType()) {
                case 4: {
                    value = object.nodeset().nextNode();
                    break;
                }
                case 1: {
                    value = object.bool() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 2: {
                    value = new Double(object.num());
                    break;
                }
                default: {
                    value = object.str();
                }
            }
            return value;
        }
        catch (TransformerException e) {
            throw new JRException("util.xml.xalan.xpath.selection.failure", new Object[]{expression}, e);
        }
    }

    protected boolean containsPrefixes(String expression) {
        String[] tokens;
        for (String token : tokens = expression.split("::")) {
            if (token.indexOf(":") == -1) continue;
            return true;
        }
        return false;
    }

    public Map<String, String> extractXmlNamespaces(Node contextNode) throws JRException {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        XPath namespaceXPath = this.xpathFact.newXPath();
        String namespaceXPathString = "//namespace::*";
        try {
            NodeList nlist = (NodeList)namespaceXPath.evaluate(namespaceXPathString, contextNode, XPathConstants.NODESET);
            for (int i = 0; i < nlist.getLength(); ++i) {
                Node node = nlist.item(i);
                namespaces.put(node.getNodeName().substring("xmlns:".length()), node.getNodeValue());
            }
        }
        catch (XPathExpressionException ex) {
            throw new JRException("util.xml.xalan.xpath.selection.failure", new Object[]{namespaceXPathString}, ex);
        }
        return namespaces;
    }
}

