/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.awt.Color;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.type.PenEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.xml.JRBaseFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public class JRBoxFactory
extends JRBaseFactory {
    private static final Log log = LogFactory.getLog(JRBoxFactory.class);

    public Object createObject(Attributes atts) {
        JRBoxContainer boxContainer = (JRBoxContainer)this.digester.peek();
        JRLineBox box = boxContainer.getLineBox();
        JRBoxFactory.setBoxAttributes(atts, box);
        return box;
    }

    public static void setBoxAttributes(Attributes atts, JRLineBox box) {
        String padding;
        Color borderColor;
        PenEnum border = PenEnum.getByName(atts.getValue("border"));
        if (border != null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"The 'border' attribute is deprecated. Use the <pen> tag instead.");
            }
            JRPenUtil.setLinePenFromPen(border, box.getPen());
        }
        if ((borderColor = JRColorUtil.getColor(atts.getValue("borderColor"), null)) != null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"The 'borderColor' attribute is deprecated. Use the <pen> tag instead.");
            }
            box.getPen().setLineColor(borderColor);
        }
        if ((padding = atts.getValue("padding")) != null && padding.length() > 0) {
            box.setPadding(Integer.parseInt(padding));
        }
        if ((border = PenEnum.getByName(atts.getValue("topBorder"))) != null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"The 'topBorder' attribute is deprecated. Use the <pen> tag instead.");
            }
            JRPenUtil.setLinePenFromPen(border, box.getTopPen());
        }
        if ((borderColor = JRColorUtil.getColor(atts.getValue("topBorderColor"), Color.black)) != null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"The 'topBorderColor' attribute is deprecated. Use the <pen> tag instead.");
            }
            box.getTopPen().setLineColor(borderColor);
        }
        if ((padding = atts.getValue("topPadding")) != null && padding.length() > 0) {
            box.setTopPadding(Integer.parseInt(padding));
        }
        if ((border = PenEnum.getByName(atts.getValue("leftBorder"))) != null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"The 'leftBorder' attribute is deprecated. Use the <pen> tag instead.");
            }
            JRPenUtil.setLinePenFromPen(border, box.getLeftPen());
        }
        if ((borderColor = JRColorUtil.getColor(atts.getValue("leftBorderColor"), Color.black)) != null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"The 'leftBorderColor' attribute is deprecated. Use the <pen> tag instead.");
            }
            box.getLeftPen().setLineColor(borderColor);
        }
        if ((padding = atts.getValue("leftPadding")) != null && padding.length() > 0) {
            box.setLeftPadding(Integer.parseInt(padding));
        }
        if ((border = PenEnum.getByName(atts.getValue("bottomBorder"))) != null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"The 'bottomBorder' attribute is deprecated. Use the <pen> tag instead.");
            }
            JRPenUtil.setLinePenFromPen(border, box.getBottomPen());
        }
        if ((borderColor = JRColorUtil.getColor(atts.getValue("bottomBorderColor"), Color.black)) != null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"The 'bottomBorderColor' attribute is deprecated. Use the <pen> tag instead.");
            }
            box.getBottomPen().setLineColor(borderColor);
        }
        if ((padding = atts.getValue("bottomPadding")) != null && padding.length() > 0) {
            box.setBottomPadding(Integer.parseInt(padding));
        }
        if ((border = PenEnum.getByName(atts.getValue("rightBorder"))) != null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"The 'rightBorder' attribute is deprecated. Use the <pen> tag instead.");
            }
            JRPenUtil.setLinePenFromPen(border, box.getRightPen());
        }
        if ((borderColor = JRColorUtil.getColor(atts.getValue("rightBorderColor"), Color.black)) != null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"The 'rightBorderColor' attribute is deprecated. Use the <pen> tag instead.");
            }
            box.getRightPen().setLineColor(borderColor);
        }
        if ((padding = atts.getValue("rightPadding")) != null && padding.length() > 0) {
            box.setRightPadding(Integer.parseInt(padding));
        }
    }
}

