/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.reporting;

import com.radensolutions.reporting.AppContextConfig;
import com.radensolutions.reporting.service.Connector;
import com.radensolutions.reporting.service.ReportManager;
import com.radensolutions.reporting.service.ServerSettings;
import java.io.IOException;
import java.util.Set;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import org.apache.commons.daemon.Daemon;
import org.apache.commons.daemon.DaemonContext;
import org.apache.commons.daemon.DaemonInitException;
import org.apache.commons.dbcp.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class Launcher
implements Daemon {
    private static final Logger log = LoggerFactory.getLogger(Launcher.class);
    private static final Object shutdownLatch = new Object();
    private AnnotationConfigApplicationContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Launcher launcher = new Launcher();
        Launcher.registerShutdownHook();
        launcher.init(null);
        launcher.start();
        while (true) {
            Object object = shutdownLatch;
            synchronized (object) {
                try {
                    shutdownLatch.wait();
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
        launcher.stop();
    }

    public void init(DaemonContext daemonContext) throws DaemonInitException, Exception {
        log.info("Initializing daemon");
        this.context = new AnnotationConfigApplicationContext();
        this.context.register(new Class[]{AppContextConfig.class});
        this.context.refresh();
        this.context.registerShutdownHook();
        Launcher.registerReportingDataSources(this.context);
        DefaultJasperReportsContext jrContext = DefaultJasperReportsContext.getInstance();
        jrContext.setProperty("net.sf.jasperreports.query.executer.factory.nxcl", "com.radensolutions.reporting.custom.NXCLQueryExecutorFactoryDummy");
        ReportManager reportManager = (ReportManager)this.context.getBean(ReportManager.class);
        log.info("Report deployment started");
        reportManager.deploy();
        log.info("All reports successful deployed");
    }

    public void start() throws IOException {
        log.info("Starting up");
        Connector connector = (Connector)this.context.getBean(Connector.class);
        connector.start();
        log.info("Connector started");
    }

    public void stop() {
        log.info("Shutdown initiated");
        Connector connector = (Connector)this.context.getBean(Connector.class);
        connector.stop();
        log.info("Connector stopped");
    }

    public void destroy() {
    }

    private static void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = shutdownLatch;
                synchronized (object) {
                    shutdownLatch.notify();
                }
            }
        });
    }

    private static void registerReportingDataSources(AnnotationConfigApplicationContext context) {
        ServerSettings settings = (ServerSettings)context.getBean(ServerSettings.class);
        Set<String> registeredDataSources = settings.getReportingDataSources();
        for (String name : registeredDataSources) {
            RootBeanDefinition definition = new RootBeanDefinition(BasicDataSource.class);
            ServerSettings.DataSourceConfig dataSourceConfig = settings.getDataSourceConfig(name);
            definition.getPropertyValues().add("driverClassName", (Object)dataSourceConfig.getDriver());
            definition.getPropertyValues().add("url", (Object)dataSourceConfig.getUrl());
            definition.getPropertyValues().add("username", (Object)dataSourceConfig.getUsername());
            definition.getPropertyValues().add("password", (Object)dataSourceConfig.getPassword());
            context.registerBeanDefinition(name, (BeanDefinition)definition);
        }
    }
}

