/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.RackOrientation;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.Rack;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.RackDiagramConfig;
import org.netxms.ui.eclipse.objectview.widgets.RackWidget;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class RackDiagramElement
extends ElementWidget {
    private RackWidget rackFrontWidget;
    private RackWidget rackRearWidget;
    private NXCSession session;
    private RackDiagramConfig config;
    private Composite rackArea;

    protected RackDiagramElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = RackDiagramConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new RackDiagramConfig();
        }
        this.session = ConsoleSharedData.getSession();
        Rack rack = (Rack)this.session.findObjectById(this.config.getObjectId(), Rack.class);
        if (rack != null) {
            this.rackArea = new Composite((Composite)this, 0){

                public Point computeSize(int wHint, int hHint, boolean changed) {
                    if (RackDiagramElement.this.rackFrontWidget == null || RackDiagramElement.this.rackRearWidget == null || hHint == -1) {
                        return super.computeSize(wHint, hHint, changed);
                    }
                    Point s = RackDiagramElement.this.rackFrontWidget.computeSize(wHint, hHint, changed);
                    return new Point(s.x * 2, s.y);
                }
            };
            this.rackArea.setBackground(SharedColors.getColor((String)"Rack.Background", (Display)parent.getDisplay()));
            this.rackArea.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    if (RackDiagramElement.this.rackFrontWidget == null || RackDiagramElement.this.rackRearWidget == null) {
                        return;
                    }
                    int height = ((RackDiagramElement)RackDiagramElement.this).rackArea.getSize().y;
                    Point size = RackDiagramElement.this.rackFrontWidget.computeSize(-1, height, true);
                    RackDiagramElement.this.rackFrontWidget.setSize(size);
                    RackDiagramElement.this.rackRearWidget.setSize(size);
                    RackDiagramElement.this.rackRearWidget.setLocation(size.x, 0);
                }
            });
            this.setRackFrontWidget(new RackWidget(this.rackArea, 0, rack, RackOrientation.FRONT));
            this.setRackRearWidget(new RackWidget(this.rackArea, 0, rack, RackOrientation.REAR));
        }
        this.setLayout((Layout)new FillLayout());
    }

    public RackWidget getRackRearWidget() {
        return this.rackRearWidget;
    }

    public void setRackRearWidget(RackWidget rackRearWidget) {
        this.rackRearWidget = rackRearWidget;
    }

    public RackWidget getRackFrontWidget() {
        return this.rackFrontWidget;
    }

    public void setRackFrontWidget(RackWidget rackFrontWidget) {
        this.rackFrontWidget = rackFrontWidget;
    }
}

