/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.propertypages;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.ui.eclipse.datacollection.propertypages.helpers.DCIPropertyPageDialog;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.perfview.PerfTabGraphSettings;
import org.netxms.ui.eclipse.perfview.widgets.YAxisRangeEditor;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class PerfTab
extends DCIPropertyPageDialog {
    private DataCollectionItem dci;
    private PerfTabGraphSettings settings;
    private Button checkShow;
    private Button checkLogScale;
    private Button checkStacked;
    private Button checkShowLegendAlways;
    private Button checkExtendedLegend;
    private LabeledText title;
    private LabeledText name;
    private ColorSelector color;
    private Combo type;
    private Spinner orderNumber;
    private Button checkShowThresholds;
    private LabeledText groupName;
    private Spinner timeRange;
    private Combo timeUnits;
    private YAxisRangeEditor yAxisRange;

    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dci = this.editor.getObjectAsItem();
        try {
            this.settings = PerfTabGraphSettings.createFromXml(this.dci.getPerfTabSettings());
        }
        catch (Exception exception) {
            this.settings = new PerfTabGraphSettings();
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 4;
        dialogArea.setLayout((Layout)layout);
        this.checkShow = new Button(dialogArea, 32);
        Messages.get();
        this.checkShow.setText(Messages.PerfTab_ShowOnPerfTab);
        this.checkShow.setSelection(this.settings.isEnabled());
        GridData gd = new GridData();
        gd.horizontalSpan = layout.numColumns;
        this.checkShow.setLayoutData((Object)gd);
        this.title = new LabeledText(dialogArea, 0);
        Messages.get();
        this.title.setLabel(Messages.PerfTab_Title);
        this.title.setText(this.settings.getTitle());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.title.setLayoutData((Object)gd);
        Composite colors = new Composite(dialogArea, 0);
        colors.setLayout((Layout)new RowLayout(512));
        Label label = new Label(colors, 0);
        Messages.get();
        label.setText(Messages.PerfTab_Color);
        this.color = new ColorSelector(colors);
        this.color.setColorValue(ColorConverter.rgbFromInt((int)this.settings.getColorAsInt()));
        Messages.get();
        this.type = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)Messages.PerfTab_Type, (Object)new GridData(16384, 0x1000000, false, false));
        Messages.get();
        this.type.add(Messages.PerfTab_Line);
        Messages.get();
        this.type.add(Messages.PerfTab_Area);
        this.type.select(this.settings.getType());
        Messages.get();
        this.orderNumber = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)Messages.PerfTab_Order, (int)0, (int)65535, (Object)new GridData(16384, 0x1000000, false, false));
        this.orderNumber.setSelection(this.settings.getOrder());
        this.groupName = new LabeledText(dialogArea, 0);
        this.groupName.setLabel("Group");
        this.groupName.setText(this.settings.getGroupName());
        gd = new GridData();
        gd.horizontalSpan = layout.numColumns;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.groupName.setLayoutData((Object)gd);
        this.name = new LabeledText(dialogArea, 0);
        Messages.get();
        this.name.setLabel(Messages.PerfTab_NameInLegend);
        this.name.setText(this.settings.getName());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = layout.numColumns;
        this.name.setLayoutData((Object)gd);
        Group timeGroup = new Group(dialogArea, 0);
        Messages.get();
        timeGroup.setText(Messages.PerfTab_TeimePeriod);
        GridLayout timeGroupLayout = new GridLayout();
        timeGroupLayout.marginWidth = 4;
        timeGroupLayout.marginHeight = 4;
        timeGroupLayout.horizontalSpacing = 16;
        timeGroupLayout.makeColumnsEqualWidth = true;
        timeGroupLayout.numColumns = 1;
        timeGroup.setLayout((Layout)timeGroupLayout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = timeGroupLayout.numColumns;
        timeGroup.setLayoutData((Object)gd);
        Composite timeRangeArea = new Composite((Composite)timeGroup, 0);
        timeGroupLayout = new GridLayout();
        timeGroupLayout.numColumns = 2;
        timeGroupLayout.marginWidth = 0;
        timeGroupLayout.marginHeight = 0;
        timeGroupLayout.horizontalSpacing = 5;
        timeRangeArea.setLayout((Layout)timeGroupLayout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        timeRangeArea.setLayoutData((Object)gd);
        Messages.get();
        this.timeRange = WidgetHelper.createLabeledSpinner((Composite)timeRangeArea, (int)2048, (String)Messages.PerfTab_TimeInterval, (int)1, (int)10000, (Object)"WidgetHelper::default_layout_data");
        this.timeRange.setSelection(this.settings.getTimeRange());
        Messages.get();
        this.timeUnits = WidgetHelper.createLabeledCombo((Composite)timeRangeArea, (int)8, (String)Messages.PerfTab_TimeUnits, (Object)"WidgetHelper::default_layout_data");
        Messages.get();
        this.timeUnits.add(Messages.PerfTab_Minutes);
        Messages.get();
        this.timeUnits.add(Messages.PerfTab_Hours);
        Messages.get();
        this.timeUnits.add(Messages.PerfTab_Days);
        this.timeUnits.select(this.settings.getTimeUnits());
        Group optionsGroup = new Group(dialogArea, 0);
        Messages.get();
        optionsGroup.setText(Messages.PerfTab_Options);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        gd.verticalSpan = 2;
        optionsGroup.setLayoutData((Object)gd);
        GridLayout optionsLayout = new GridLayout();
        optionsGroup.setLayout((Layout)optionsLayout);
        this.checkShowThresholds = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkShowThresholds.setText(Messages.PerfTab_ShowThresholds);
        this.checkShowThresholds.setSelection(this.settings.isShowThresholds());
        gd = new GridData();
        gd.horizontalSpan = layout.numColumns;
        this.checkShowThresholds.setLayoutData((Object)gd);
        this.checkLogScale = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkLogScale.setText(Messages.PerfTab_LogarithmicScale);
        this.checkLogScale.setSelection(this.settings.isLogScaleEnabled());
        gd = new GridData();
        gd.horizontalSpan = layout.numColumns;
        this.checkLogScale.setLayoutData((Object)gd);
        this.checkStacked = new Button((Composite)optionsGroup, 32);
        this.checkStacked.setText("&Stacked");
        this.checkStacked.setSelection(this.settings.isStacked());
        gd = new GridData();
        gd.horizontalSpan = layout.numColumns;
        this.checkStacked.setLayoutData((Object)gd);
        this.checkShowLegendAlways = new Button((Composite)optionsGroup, 32);
        this.checkShowLegendAlways.setText("Always show &legend");
        this.checkShowLegendAlways.setSelection(this.settings.isShowLegendAlways());
        gd = new GridData();
        gd.horizontalSpan = layout.numColumns;
        this.checkShowLegendAlways.setLayoutData((Object)gd);
        this.checkExtendedLegend = new Button((Composite)optionsGroup, 32);
        this.checkExtendedLegend.setText("&Extended legend");
        this.checkExtendedLegend.setSelection(this.settings.isExtendedLegend());
        gd = new GridData();
        gd.horizontalSpan = layout.numColumns;
        this.checkExtendedLegend.setLayoutData((Object)gd);
        this.yAxisRange = new YAxisRangeEditor(dialogArea, 0);
        gd = new GridData();
        gd.horizontalSpan = layout.numColumns;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.yAxisRange.setLayoutData(gd);
        this.yAxisRange.setSelection(this.settings.isAutoScale(), this.settings.modifyYBase(), this.settings.getMinYScaleValue(), this.settings.getMaxYScaleValue());
        return dialogArea;
    }

    private void applyChanges(boolean isApply) {
        this.settings.setEnabled(this.checkShow.getSelection());
        this.settings.setLogScaleEnabled(this.checkLogScale.getSelection());
        this.settings.setTitle(this.title.getText());
        this.settings.setName(this.name.getText());
        this.settings.setColor(ColorConverter.rgbToInt((RGB)this.color.getColorValue()));
        this.settings.setType(this.type.getSelectionIndex());
        this.settings.setOrder(this.orderNumber.getSelection());
        this.settings.setGroupName(this.groupName.getText().trim());
        this.settings.setShowThresholds(this.checkShowThresholds.getSelection());
        this.settings.setStacked(this.checkStacked.getSelection());
        this.settings.setShowLegendAlways(this.checkShowLegendAlways.getSelection());
        this.settings.setExtendedLegend(this.checkExtendedLegend.getSelection());
        this.settings.setAutoScale(this.yAxisRange.isAuto());
        this.settings.setMinYScaleValue(this.yAxisRange.getMinY());
        this.settings.setMaxYScaleValue(this.yAxisRange.getMaxY());
        this.settings.setModifyYBase(this.yAxisRange.modifyYBase());
        this.settings.setTimeRange(this.timeRange.getSelection());
        this.settings.setTimeUnits(this.timeUnits.getSelectionIndex());
        try {
            this.dci.setPerfTabSettings(this.settings.createXml());
        }
        catch (Exception exception) {
            this.dci.setPerfTabSettings(null);
        }
        this.editor.modify();
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        PerfTabGraphSettings defaults = new PerfTabGraphSettings();
        this.checkShow.setSelection(defaults.isEnabled());
        this.title.setText(defaults.getTitle());
        this.color.setColorValue(ColorConverter.rgbFromInt((int)defaults.getColorAsInt()));
        this.groupName.setText("");
        this.orderNumber.setSelection(100);
    }
}

