/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.objecttabs.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.Severity;
import org.netxms.client.objects.ClusterResource;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ClusterResourceListLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private NXCSession session = ConsoleSharedData.getSession();

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return StatusDisplayInfo.getStatusImage((Severity)(((ClusterResource)element).getCurrentOwner() != 0L ? Severity.NORMAL : Severity.MAJOR));
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ((ClusterResource)element).getName();
            }
            case 1: {
                return ((ClusterResource)element).getVirtualAddress().getHostAddress();
            }
            case 2: {
                long ownerId = ((ClusterResource)element).getCurrentOwner();
                if (ownerId > 0L) {
                    Node owner = (Node)this.session.findObjectById(ownerId, Node.class);
                    return owner != null ? owner.getObjectName() : "<" + Long.toString(ownerId) + ">";
                }
                Messages.get();
                return Messages.ClusterResourceListLabelProvider_None;
            }
        }
        return null;
    }
}

