/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.propertypages;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.networkmaps.views.helpers.LinkEditor;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class MapLinkGeneral
extends PropertyPage {
    private LinkEditor object;
    private LabeledText name;
    private LabeledText connector1;
    private LabeledText connector2;
    private Button radioColorDefault;
    private Button radioColorObject;
    private Button radioColorCustom;
    private ColorSelector color;
    private List list;
    private Button add;
    private Button remove;
    private Combo routingAlgorithm;

    protected Control createContents(Composite parent) {
        this.object = (LinkEditor)this.getElement().getAdapter(LinkEditor.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        Messages.get();
        this.name.setLabel(Messages.MapLinkGeneral_Name);
        this.name.setText(this.object.getName());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.name.setLayoutData((Object)gd);
        this.connector1 = new LabeledText(dialogArea, 0);
        Messages.get();
        this.connector1.setLabel(Messages.MapLinkGeneral_NameConn1);
        this.connector1.setText(this.object.getConnectorName1());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.connector1.setLayoutData((Object)gd);
        this.connector2 = new LabeledText(dialogArea, 0);
        Messages.get();
        this.connector2.setLabel(Messages.MapLinkGeneral_NameConn2);
        this.connector2.setText(this.object.getConnectorName2());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.connector2.setLayoutData((Object)gd);
        Group colorGroup = new Group(dialogArea, 0);
        Messages.get();
        colorGroup.setText(Messages.MapLinkGeneral_Color);
        layout = new GridLayout();
        colorGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        colorGroup.setLayoutData((Object)gd);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MapLinkGeneral.this.color.setEnabled(MapLinkGeneral.this.radioColorCustom.getSelection());
                MapLinkGeneral.this.list.setEnabled(MapLinkGeneral.this.radioColorObject.getSelection());
                MapLinkGeneral.this.add.setEnabled(MapLinkGeneral.this.radioColorObject.getSelection());
                MapLinkGeneral.this.remove.setEnabled(MapLinkGeneral.this.radioColorObject.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.radioColorDefault = new Button((Composite)colorGroup, 16);
        Messages.get();
        this.radioColorDefault.setText(Messages.MapLinkGeneral_DefColor);
        this.radioColorDefault.setSelection(this.object.getColor() < 0 && this.object.getStatusObject().size() == 0);
        this.radioColorDefault.addSelectionListener(listener);
        this.radioColorObject = new Button((Composite)colorGroup, 16);
        Messages.get();
        this.radioColorObject.setText(Messages.MapLinkGeneral_BasedOnObjStatus);
        this.radioColorObject.setSelection(this.object.getStatusObject().size() != 0);
        this.radioColorObject.addSelectionListener(listener);
        Composite nodeSelectionGroup = new Composite((Composite)colorGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        nodeSelectionGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        nodeSelectionGroup.setLayoutData((Object)gd);
        this.list = new List(nodeSelectionGroup, 2820);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalSpan = 2;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        this.list.setLayoutData((Object)gd);
        if (this.object.getStatusObject() != null) {
            int i = 0;
            while (i < this.object.getStatusObject().size()) {
                AbstractObject obj = ConsoleSharedData.getSession().findObjectById(this.object.getStatusObject().get(i).longValue());
                this.list.add(obj != null ? obj.getObjectName() : "<" + Long.toString(this.object.getStatusObject().get(i)) + ">");
                ++i;
            }
        }
        this.list.setEnabled(this.radioColorObject.getSelection());
        this.add = new Button(nodeSelectionGroup, 8);
        Messages.get();
        this.add.setText(Messages.MapLinkGeneral_Add);
        gd = new GridData();
        gd.widthHint = 90;
        gd.verticalAlignment = 128;
        this.add.setLayoutData((Object)gd);
        this.add.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                MapLinkGeneral.this.addObject();
            }
        });
        this.add.setEnabled(this.radioColorObject.getSelection());
        this.remove = new Button(nodeSelectionGroup, 8);
        Messages.get();
        this.remove.setText(Messages.MapLinkGeneral_Delete);
        gd.widthHint = 90;
        gd.verticalAlignment = 128;
        this.remove.setLayoutData((Object)gd);
        this.remove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                MapLinkGeneral.this.removeObject();
            }
        });
        this.remove.setEnabled(this.radioColorObject.getSelection());
        this.radioColorCustom = new Button((Composite)colorGroup, 16);
        Messages.get();
        this.radioColorCustom.setText(Messages.MapLinkGeneral_CustomColor);
        this.radioColorCustom.setSelection(this.object.getColor() >= 0 && this.object.getStatusObject().size() == 0);
        this.radioColorCustom.addSelectionListener(listener);
        this.color = new ColorSelector((Composite)colorGroup);
        if (this.radioColorCustom.getSelection()) {
            this.color.setColorValue(ColorConverter.rgbFromInt((int)this.object.getColor()));
        } else {
            this.color.setEnabled(false);
        }
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.color.getButton().setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        Messages.get();
        this.routingAlgorithm = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)Messages.MapLinkGeneral_RoutingAlg, (Object)gd);
        Messages.get();
        this.routingAlgorithm.add(Messages.MapLinkGeneral_MapDefault);
        Messages.get();
        this.routingAlgorithm.add(Messages.MapLinkGeneral_Direct);
        Messages.get();
        this.routingAlgorithm.add(Messages.MapLinkGeneral_Manhattan);
        Messages.get();
        this.routingAlgorithm.add(Messages.MapLinkGeneral_BendPoints);
        this.routingAlgorithm.select(this.object.getRoutingAlgorithm());
        return dialogArea;
    }

    private void addObject() {
        AbstractObject[] objects;
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell(), null, null);
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0 && (objects = dlg.getSelectedObjects(AbstractObject.class)).length > 0) {
            AbstractObject[] abstractObjectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractObject obj = abstractObjectArray[n2];
                this.object.addStatusObject(obj.getObjectId());
                this.list.add(obj != null ? obj.getObjectName() : "<" + Long.toString(obj.getObjectId()) + ">");
                ++n2;
            }
        }
    }

    private void removeObject() {
        int index = this.list.getSelectionIndex();
        this.list.remove(index);
        this.object.removeStatusObjectByIndex(index);
    }

    private boolean applyChanges(boolean isApply) {
        this.object.setName(this.name.getText());
        this.object.setConnectorName1(this.connector1.getText());
        this.object.setConnectorName2(this.connector2.getText());
        if (this.radioColorCustom.getSelection()) {
            this.object.setColor(ColorConverter.rgbToInt((RGB)this.color.getColorValue()));
            this.object.setStatusObject(null);
        } else if (this.radioColorObject.getSelection()) {
            this.object.setColor(-1);
        } else {
            this.object.setColor(-1);
            this.object.setStatusObject(null);
        }
        this.object.setRoutingAlgorithm(this.routingAlgorithm.getSelectionIndex());
        this.object.update();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

