/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ApplyPolicy
implements IObjectActionDelegate {
    private Shell shell;
    private List<AbstractObject> selectedObjects = null;

    public void run(IAction action) {
        final ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.shell, null, ObjectSelectionDialog.createPolicySelectionFilter());
        dlg.showFilterToolTip(false);
        if (dlg.open() == 0) {
            final NXCSession session = ConsoleSharedData.getSession();
            new ConsoleJob("Deploy agent policy", null, "org.netxms.ui.eclipse.objectmanager", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    int i = 0;
                    while (i < ApplyPolicy.this.selectedObjects.size()) {
                        int n = 0;
                        while (n < dlg.getSelectedObjects().size()) {
                            session.deployAgentPolicy(((AbstractObject)dlg.getSelectedObjects().get(n)).getObjectId(), ((AbstractObject)ApplyPolicy.this.selectedObjects.get(i)).getObjectId());
                            ++n;
                        }
                        ++i;
                    }
                }

                protected String getErrorMessage() {
                    return "Cannot deploy agent policy";
                }
            }.start();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() != 0) {
            this.selectedObjects = new ArrayList<AbstractObject>();
            for (Object s : ((IStructuredSelection)selection).toList()) {
                if (!(s instanceof Node) && !(s instanceof Interface) && !(s instanceof AccessPoint)) continue;
                action.setEnabled(true);
                this.selectedObjects.add((AbstractObject)s);
            }
        } else {
            action.setEnabled(false);
            this.selectedObjects = null;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }
}

