/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Zone;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectSelectionFilterFactory;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ZoneCommunications
extends PropertyPage {
    private Zone zone;
    private ObjectSelector agentProxy;

    protected Control createContents(Composite parent) {
        this.zone = (Zone)this.getElement().getAdapter(Zone.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout dialogLayout = new GridLayout();
        dialogLayout.marginWidth = 0;
        dialogLayout.marginHeight = 0;
        dialogArea.setLayout((Layout)dialogLayout);
        this.agentProxy = new ObjectSelector(dialogArea, 0, true);
        Messages.get();
        this.agentProxy.setLabel(Messages.ZoneCommunications_DefaultProxy);
        this.agentProxy.setClassFilter(ObjectSelectionFilterFactory.getInstance().createNodeSelectionFilter(false));
        this.agentProxy.setObjectId(this.zone.getProxyNodeId());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.agentProxy.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        final NXCObjectModificationData md = new NXCObjectModificationData(this.zone.getObjectId());
        md.setZoneProxy(this.agentProxy.getObjectId());
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(String.format(Messages.ZoneCommunications_JobName, this.zone.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ZoneCommunications_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ZoneCommunications.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.agentProxy.setObjectId(0L);
    }
}

