/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.widgets;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.IGenerator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Palette;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.PaletteImpl;
import org.eclipse.birt.chart.script.IScriptClassLoader;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.netxms.ui.eclipse.charts.Activator;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.widgets.GenericChart;
import org.netxms.ui.eclipse.tools.ColorCache;

public abstract class GenericBirtChart
extends GenericChart
implements PaintListener,
ControlListener {
    private Chart chart = null;
    private boolean fullRepaint = true;
    private IDeviceRenderer deviceRenderer = null;
    private GC gcImage = null;
    private GeneratedChartState generatedChartState = null;
    private IGenerator generator = null;
    private Image imgChart = null;
    private ColorCache colors;
    private Set<String> errors = new HashSet<String>(0);
    private Image errorImage = null;
    protected boolean autoscale = true;
    protected int from;
    protected int to;

    public GenericBirtChart(Composite parent, int style) {
        super(parent, style | 0x40000);
        this.colors = new ColorCache((Control)this);
        try {
            PlatformConfig config = new PlatformConfig();
            config.setBIRTHome("");
            ChartEngine chartEngine = ChartEngine.instance((PlatformConfig)config);
            this.deviceRenderer = chartEngine.getRenderer("dv.SWT");
            this.generator = chartEngine.getGenerator();
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
        this.addPaintListener(this);
        this.addControlListener(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (GenericBirtChart.this.imgChart != null && !GenericBirtChart.this.imgChart.isDisposed()) {
                    GenericBirtChart.this.imgChart.dispose();
                }
                if (GenericBirtChart.this.gcImage != null && !GenericBirtChart.this.gcImage.isDisposed()) {
                    GenericBirtChart.this.gcImage.dispose();
                }
            }
        });
    }

    @Override
    public void initializationComplete() {
        this.chart = this.createChart();
        this.fullRepaint = true;
        this.redraw();
    }

    protected void recreateChart() {
        this.chart = this.createChart();
        this.fullRepaint = true;
        this.redraw();
    }

    protected abstract Chart createChart();

    public Chart getChart() {
        return this.chart;
    }

    public void controlMoved(ControlEvent arg0) {
        this.fullRepaint = true;
    }

    public void controlResized(ControlEvent arg0) {
        this.fullRepaint = true;
    }

    public final void paintControl(PaintEvent event) {
        if (this.chart == null) {
            return;
        }
        Rectangle clientArea = this.getClientArea();
        if (clientArea.width == 0 || clientArea.height == 0) {
            return;
        }
        if (this.fullRepaint) {
            if (this.imgChart != null && !this.imgChart.isDisposed()) {
                this.imgChart.dispose();
            }
            if (this.gcImage != null && !this.gcImage.isDisposed()) {
                this.gcImage.dispose();
            }
            this.imgChart = new Image((Device)this.getDisplay(), clientArea);
            this.gcImage = new GC((Drawable)this.imgChart);
            this.deviceRenderer.setProperty("device.output.context", (Object)this.gcImage);
            Bounds bounds = BoundsImpl.create((double)0.0, (double)0.0, (double)clientArea.width, (double)clientArea.height);
            bounds.scale(72.0 / (double)this.deviceRenderer.getDisplayServer().getDpiResolution());
            try {
                this.chart.setScript("org.netxms.ui.eclipse.charts.widgets.internal.AxisLabelFormatter");
                RunTimeContext rtc = new RunTimeContext();
                rtc.setScriptClassLoader(new IScriptClassLoader(){

                    public Class<?> loadClass(String className, ClassLoader parentLoader) throws ClassNotFoundException {
                        return this.getClass().getClassLoader().loadClass(className);
                    }
                });
                this.generatedChartState = this.generator.build(this.deviceRenderer.getDisplayServer(), this.chart, bounds, null, rtc, null);
                this.generator.render(this.deviceRenderer, this.generatedChartState);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.fullRepaint = false;
        }
        event.gc.drawImage(this.imgChart, clientArea.x, clientArea.y);
        this.paintErrorIndicator(event.gc);
    }

    @Override
    public void refresh() {
        this.fullRepaint = true;
        this.redraw();
    }

    @Override
    public void rebuild() {
        this.recreateChart();
    }

    @Override
    public void setChartTitle(String title) {
        this.title = title;
        if (this.chart != null) {
            this.chart.getTitle().getLabel().getCaption().setValue(title);
            this.refresh();
        }
    }

    @Override
    public void setLegendVisible(boolean visible) {
        this.legendVisible = visible;
        if (this.chart != null) {
            this.chart.getLegend().setVisible(visible);
            this.refresh();
        }
    }

    @Override
    public void setTitleVisible(boolean visible) {
        this.titleVisible = visible;
        if (this.chart != null) {
            this.chart.getTitle().setVisible(visible);
        }
    }

    @Override
    public void set3DModeEnabled(boolean enabled) {
        this.displayIn3D = enabled;
        if (this.chart != null) {
            this.recreateChart();
        }
    }

    protected Palette getBirtPalette() {
        Palette birtPalette = PaletteImpl.create((int)0, (boolean)true);
        ChartColor[] chartColorArray = this.palette;
        int n = this.palette.length;
        int n2 = 0;
        while (n2 < n) {
            ChartColor c = chartColorArray[n2];
            birtPalette.getEntries().add((Object)ColorDefinitionImpl.create((int)c.red, (int)c.green, (int)c.blue, (int)c.alpha));
            ++n2;
        }
        return birtPalette;
    }

    @Override
    public void setLogScaleEnabled(boolean enabled) {
        if (this.useLogScale != enabled) {
            this.useLogScale = enabled;
            if (this.chart != null) {
                this.recreateChart();
            }
        }
    }

    protected ColorDefinition getColorFromPreferences(String name) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)name);
        return ColorDefinitionImpl.create((int)rgb.red, (int)rgb.green, (int)rgb.blue);
    }

    protected Position positionFromInt(int value) {
        switch (value) {
            case 1: {
                return Position.LEFT_LITERAL;
            }
            case 2: {
                return Position.RIGHT_LITERAL;
            }
            case 4: {
                return Position.ABOVE_LITERAL;
            }
            case 8: {
                return Position.BELOW_LITERAL;
            }
        }
        return Position.RIGHT_LITERAL;
    }

    @Override
    public void setLegendPosition(int position) {
        super.setLegendPosition(position);
        if (this.chart != null) {
            this.recreateChart();
        }
    }

    @Override
    public void setTranslucent(boolean translucent) {
        super.setTranslucent(translucent);
        if (this.chart != null) {
            this.recreateChart();
        }
    }

    @Override
    public void addError(String message) {
        if (this.errors.add(message)) {
            this.redraw();
        }
    }

    @Override
    public void clearErrors() {
        if (this.errors.size() > 0) {
            this.errors.clear();
            this.redraw();
        }
    }

    private void paintErrorIndicator(GC gc) {
        if (this.errors.size() == 0) {
            return;
        }
        if (this.errorImage == null) {
            this.errorImage = Activator.getImageDescriptor("icons/chart_error.png").createImage();
        }
        gc.setAlpha(127);
        gc.setBackground(this.colors.create(127, 127, 127));
        gc.fillRectangle(this.getClientArea());
        gc.setAlpha(255);
        gc.drawImage(this.errorImage, 10, 10);
        gc.setForeground(this.colors.create(192, 0, 0));
        Iterator<String> it = this.errors.iterator();
        int y = 12;
        int h = gc.textExtent((String)"X").y;
        while (it.hasNext()) {
            gc.drawText(it.next(), 40, y, true);
            y += h + 5;
        }
    }

    @Override
    public void setYAxisRange(int from, int to) {
        if (from == to) {
            return;
        }
        if (from > to) {
            int tmp = to;
            to = from;
            from = tmp;
        }
        this.autoscale = false;
        this.from = from;
        this.to = to;
    }
}

