/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.widgets;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.constants.ColumnFilterType;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.EventTemplate;
import org.netxms.client.log.ColumnFilter;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.eventmanager.dialogs.EventSelectionDialog;
import org.netxms.ui.eclipse.logviewer.Messages;
import org.netxms.ui.eclipse.logviewer.widgets.ConditionEditor;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class EventConditionEditor
extends ConditionEditor {
    private static final String[] OPERATIONS;
    private static final String EMPTY_SELECTION_TEXT;
    private WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
    private long eventCode = 0L;
    private CLabel objectName;

    static {
        String[] stringArray = new String[2];
        Messages.get();
        stringArray[0] = Messages.EventConditionEditor_Is;
        Messages.get();
        stringArray[1] = Messages.EventConditionEditor_IsNot;
        OPERATIONS = stringArray;
        Messages.get();
        EMPTY_SELECTION_TEXT = Messages.EventConditionEditor_None;
    }

    public EventConditionEditor(Composite parent, FormToolkit toolkit) {
        super(parent, toolkit);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EventConditionEditor.this.labelProvider.dispose();
            }
        });
    }

    @Override
    protected String[] getOperations() {
        return OPERATIONS;
    }

    @Override
    protected void createContent(Composite parent, ColumnFilter initialFilter) {
        Composite group = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 2;
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gd);
        this.objectName = new CLabel(group, 0);
        this.toolkit.adapt((Composite)this.objectName);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        this.objectName.setLayoutData((Object)gd);
        this.objectName.setText(EMPTY_SELECTION_TEXT);
        ImageHyperlink selectionLink = this.toolkit.createImageHyperlink(group, 0);
        selectionLink.setImage(SharedIcons.IMG_FIND);
        selectionLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                EventConditionEditor.this.selectEvent();
            }
        });
        if (initialFilter != null && initialFilter.getType() == ColumnFilterType.EQUALS) {
            this.setSelectedOperation(initialFilter.isNegated() ? 1 : 0);
            this.eventCode = initialFilter.getNumericValue();
            EventTemplate e = ConsoleSharedData.getSession().findEventTemplateByCode(this.eventCode);
            if (e != null) {
                this.objectName.setText(e.getName());
                this.objectName.setImage(this.labelProvider.getImage((Object)e));
            } else {
                this.objectName.setImage(StatusDisplayInfo.getStatusImage((Severity)Severity.UNKNOWN));
                this.objectName.setText("[" + this.eventCode + "]");
            }
        }
    }

    private void selectEvent() {
        EventSelectionDialog dlg = new EventSelectionDialog(this.getShell());
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            EventTemplate[] events = dlg.getSelectedEvents();
            if (events.length > 0) {
                this.eventCode = events[0].getCode();
                this.objectName.setText(events[0].getName());
                this.objectName.setImage(this.labelProvider.getImage((Object)events[0]));
            } else {
                this.eventCode = 0L;
                this.objectName.setText(EMPTY_SELECTION_TEXT);
                this.objectName.setImage(null);
            }
        }
    }

    @Override
    public ColumnFilter createFilter() {
        ColumnFilter filter = new ColumnFilter(ColumnFilterType.EQUALS, this.eventCode);
        filter.setNegated(this.getSelectedOperation() == 1);
        return filter;
    }
}

