/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.propertypages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.maps.configs.DCIImageConfiguration;
import org.netxms.client.maps.configs.DCIImageRule;
import org.netxms.client.maps.elements.NetworkMapDCIImage;
import org.netxms.ui.eclipse.networkmaps.Activator;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.networkmaps.dialogs.EditDCIImageRuleDialog;
import org.netxms.ui.eclipse.networkmaps.propertypages.helper.DCIImageRuleLabelProvider;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class DCIImageRuleList
extends PropertyPage {
    public static final int COLUMN_OPERATION = 0;
    public static final int COLUMN_COMMENT = 1;
    private static final String COLUMN_SETTINGS_PREFIX = "DCIImageRuleList.ImageRuleList";
    private NetworkMapDCIImage container;
    private DCIImageConfiguration config;
    private List<DCIImageRule> rules;
    private TableViewer RuleList;
    private Button addButton;
    private Button modifyButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;

    protected Control createContents(Composite parent) {
        this.container = (NetworkMapDCIImage)this.getElement().getAdapter(NetworkMapDCIImage.class);
        this.config = this.container.getImageOptions();
        this.rules = this.config.getRulesAsList();
        if (this.rules == null) {
            this.rules = new ArrayList<DCIImageRule>();
        }
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        Composite RuleArea = new Composite(dialogArea, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        RuleArea.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        RuleArea.setLayout((Layout)layout);
        Label label = new Label(RuleArea, 0);
        Messages.get();
        label.setText(Messages.DCIImageRuleList_Rules);
        this.RuleList = new TableViewer(RuleArea, 67586);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.RuleList.getControl().setLayoutData((Object)gd);
        this.setupRuleList();
        this.RuleList.setInput((Object)this.rules.toArray());
        Composite leftButtons = new Composite(RuleArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gd);
        RowLayout buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        leftButtons.setLayout((Layout)buttonsLayout);
        this.upButton = new Button(leftButtons, 8);
        Messages.get();
        this.upButton.setText(Messages.DCIImageRuleList_Up);
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DCIImageRuleList.this.moveUp();
            }
        });
        this.downButton = new Button(leftButtons, 8);
        Messages.get();
        this.downButton.setText(Messages.DCIImageRuleList_Down);
        this.downButton.setEnabled(false);
        this.downButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DCIImageRuleList.this.moveDown();
            }
        });
        Composite buttons = new Composite(RuleArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        buttons.setLayout((Layout)buttonsLayout);
        this.addButton = new Button(buttons, 8);
        Messages.get();
        this.addButton.setText(Messages.DCIImageRuleList_Add);
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DCIImageRuleList.this.addRule();
            }
        });
        this.modifyButton = new Button(buttons, 8);
        Messages.get();
        this.modifyButton.setText(Messages.DCIImageRuleList_Edit);
        rd = new RowData();
        rd.width = 90;
        this.modifyButton.setLayoutData((Object)rd);
        this.modifyButton.setEnabled(false);
        this.modifyButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DCIImageRuleList.this.editRule();
            }
        });
        this.deleteButton = new Button(buttons, 8);
        Messages.get();
        this.deleteButton.setText(Messages.DCIImageRuleList_Delete);
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DCIImageRuleList.this.deleteRules();
            }
        });
        this.RuleList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                int index = DCIImageRuleList.this.rules.indexOf(selection.getFirstElement());
                DCIImageRuleList.this.upButton.setEnabled(selection.size() == 1 && index > 0);
                DCIImageRuleList.this.downButton.setEnabled(selection.size() == 1 && index >= 0 && index < DCIImageRuleList.this.rules.size() - 1);
                DCIImageRuleList.this.modifyButton.setEnabled(selection.size() == 1);
                DCIImageRuleList.this.deleteButton.setEnabled(selection.size() > 0);
            }
        });
        this.RuleList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DCIImageRuleList.this.editRule();
            }
        });
        return dialogArea;
    }

    private void deleteRules() {
        IStructuredSelection selection = (IStructuredSelection)this.RuleList.getSelection();
        if (!selection.isEmpty()) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                this.rules.remove(it.next());
            }
            this.RuleList.setInput((Object)this.rules.toArray());
        }
    }

    private void editRule() {
        IStructuredSelection selection = (IStructuredSelection)this.RuleList.getSelection();
        if (selection.size() == 1) {
            DCIImageRule rule = (DCIImageRule)selection.getFirstElement();
            EditDCIImageRuleDialog dlg = new EditDCIImageRuleDialog(this.getShell(), rule);
            if (dlg.open() == 0) {
                this.RuleList.update((Object)rule, null);
            }
        }
    }

    private void addRule() {
        DCIImageRule rule = new DCIImageRule();
        EditDCIImageRuleDialog dlg = new EditDCIImageRuleDialog(this.getShell(), rule);
        if (dlg.open() == 0) {
            this.rules.add(rule);
            this.RuleList.setInput((Object)this.rules.toArray());
            this.RuleList.setSelection((ISelection)new StructuredSelection((Object)rule));
        }
    }

    private void moveUp() {
        DCIImageRule rule;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.RuleList.getSelection();
        if (selection.size() == 1 && (index = this.rules.indexOf(rule = (DCIImageRule)selection.getFirstElement())) > 0) {
            Collections.swap(this.rules, index - 1, index);
            this.RuleList.setInput((Object)this.rules.toArray());
            this.RuleList.setSelection((ISelection)new StructuredSelection((Object)rule));
        }
    }

    private void moveDown() {
        DCIImageRule rule;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.RuleList.getSelection();
        if (selection.size() == 1 && (index = this.rules.indexOf(rule = (DCIImageRule)selection.getFirstElement())) < this.rules.size() - 1 && index >= 0) {
            Collections.swap(this.rules, index + 1, index);
            this.RuleList.setInput((Object)this.rules.toArray());
            this.RuleList.setSelection((ISelection)new StructuredSelection((Object)rule));
        }
    }

    private void setupRuleList() {
        Table table = this.RuleList.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        Messages.get();
        column.setText(Messages.DCIImageRuleList_Expression);
        column.setWidth(200);
        column = new TableColumn(table, 16384);
        Messages.get();
        column.setText(Messages.DCIImageRuleList_Comment);
        column.setWidth(150);
        WidgetHelper.restoreColumnSettings((Table)table, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)COLUMN_SETTINGS_PREFIX);
        this.RuleList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.RuleList.setLabelProvider((IBaseLabelProvider)new DCIImageRuleLabelProvider());
    }

    protected void performApply() {
        this.saveSettings();
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.saveSettings();
        this.applyChanges(false);
        return true;
    }

    protected void applyChanges(boolean isApply) {
        this.config.setDciRuleArray(this.rules.toArray(new DCIImageRule[this.rules.size()]));
    }

    public boolean performCancel() {
        this.saveSettings();
        return true;
    }

    private void saveSettings() {
        WidgetHelper.saveColumnSettings((Table)this.RuleList.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)COLUMN_SETTINGS_PREFIX);
    }
}

