/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum MapLayoutAlgorithm {
    MANUAL(Short.MAX_VALUE),
    SPRING(0),
    RADIAL(1),
    HTREE(2),
    VTREE(3),
    SPARSE_VTREE(4);

    private int value;
    private static Map<Integer, MapLayoutAlgorithm> lookupTable;

    static {
        lookupTable = new HashMap<Integer, MapLayoutAlgorithm>();
        MapLayoutAlgorithm[] mapLayoutAlgorithmArray = MapLayoutAlgorithm.values();
        int n = mapLayoutAlgorithmArray.length;
        int n2 = 0;
        while (n2 < n) {
            MapLayoutAlgorithm element = mapLayoutAlgorithmArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private MapLayoutAlgorithm(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static MapLayoutAlgorithm getByValue(int value) {
        MapLayoutAlgorithm layout = lookupTable.get(value);
        if (layout == null) {
            Logger.warning((String)"LayoutAlgorithm", (String)("Unknown layout alghoritm: " + value));
            return SPRING;
        }
        return layout;
    }
}

