/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.filemanager.views;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.AgentFileData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.filemanager.Activator;
import org.netxms.ui.eclipse.filemanager.Messages;
import org.netxms.ui.eclipse.filemanager.widgets.BaseFileViewer;
import org.netxms.ui.eclipse.filemanager.widgets.DynamicFileViewer;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class AgentFileViewer
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.filemanager.views.AgentFileViewer";
    private final NXCSession session = ConsoleSharedData.getSession();
    private DynamicFileViewer viewer;
    private String remoteFileName;
    private long nodeId;
    private boolean followChanges;
    private Action actionClear;
    private Action actionScrollLock;
    private Action actionCopy;
    private Action actionSelectAll;
    private Action actionFind;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String[] parts = site.getSecondaryId().split("&");
        if (parts.length != 2) {
            throw new PartInitException("Internal error");
        }
        this.nodeId = Long.parseLong(parts[0]);
        AbstractObject object = this.session.findObjectById(this.nodeId);
        if (object == null || object.getObjectClass() != 2) {
            Messages.get();
            throw new PartInitException(Messages.FileViewer_InvalidObjectID);
        }
        try {
            this.remoteFileName = URLDecoder.decode(parts[1], "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new PartInitException("Internal error", (Throwable)e);
        }
        this.setPartName(String.valueOf(object.getObjectName()) + ": " + this.remoteFileName);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new DynamicFileViewer(parent, 0, (IViewPart)this);
        this.viewer.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AgentFileViewer.this.actionCopy.setEnabled(AgentFileViewer.this.viewer.canCopy());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.activateContext();
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.filemanager.context.AgentFileViewer");
        }
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        Messages.get();
        this.actionClear = new Action(Messages.FileViewer_ClearOutput, SharedIcons.CLEAR_LOG){

            public void run() {
                AgentFileViewer.this.viewer.clear();
            }
        };
        this.actionClear.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.clear_output");
        handlerService.activateHandler(this.actionClear.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionClear));
        Messages.get();
        this.actionScrollLock = new Action(Messages.FileViewer_ScrollLock, 2){

            public void run() {
                AgentFileViewer.this.viewer.setScrollLock(AgentFileViewer.this.actionScrollLock.isChecked());
            }
        };
        this.actionScrollLock.setImageDescriptor(Activator.getImageDescriptor("icons/scroll_lock.gif"));
        this.actionScrollLock.setChecked(false);
        this.actionScrollLock.setActionDefinitionId("org.netxms.ui.eclipse.objecttools.commands.scroll_lock");
        handlerService.activateHandler(this.actionScrollLock.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionScrollLock));
        Messages.get();
        this.actionCopy = new Action(Messages.AgentFileViewer_Copy){

            public void run() {
                AgentFileViewer.this.viewer.copy();
            }
        };
        this.actionCopy.setEnabled(false);
        this.actionCopy.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.copy");
        handlerService.activateHandler(this.actionCopy.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionCopy));
        Messages.get();
        this.actionSelectAll = new Action(Messages.AgentFileViewer_SelectAll){

            public void run() {
                AgentFileViewer.this.viewer.selectAll();
            }
        };
        this.actionSelectAll.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.select_all");
        handlerService.activateHandler(this.actionSelectAll.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionSelectAll));
        Messages.get();
        this.actionFind = new Action(Messages.AgentFileViewer_Find, SharedIcons.FIND){

            public void run() {
                AgentFileViewer.this.viewer.showSearchBar();
            }
        };
        this.actionFind.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.find");
        handlerService.activateHandler(this.actionFind.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionFind));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionFind);
        if (this.followChanges) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionClear);
            manager.add((IAction)this.actionScrollLock);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSelectAll);
        manager.add((IAction)this.actionCopy);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionFind);
        if (this.followChanges) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionClear);
            manager.add((IAction)this.actionScrollLock);
        }
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AgentFileViewer.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getTextControl());
        this.viewer.getTextControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionFind);
        if (this.followChanges) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionClear);
            manager.add((IAction)this.actionScrollLock);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSelectAll);
        manager.add((IAction)this.actionCopy);
    }

    public void setFocus() {
        this.viewer.setFocus();
    }

    public static boolean createView(String secondaryId, long nodeId, AgentFileData file, boolean followChanges) throws PartInitException {
        return AgentFileViewer.createView(secondaryId, nodeId, file, followChanges, null);
    }

    public static boolean createView(String secondaryId, final long nodeId, final AgentFileData file, boolean followChanges, BaseFileViewer.LineStyler lineStyler) throws PartInitException {
        boolean exceedSize;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        boolean bl = exceedSize = file.getFile().length() > 0x7D0000L;
        if (exceedSize) {
            Shell shell = window.getShell();
            Messages.get();
            Messages.get();
            if (!MessageDialogHelper.openConfirm((Shell)shell, (String)Messages.AgentFileViewer_FileIsTooLarge, (String)Messages.AgentFileViewer_FileIsTooLargeMessageText)) {
                if (followChanges) {
                    final NXCSession session = ConsoleSharedData.getSession();
                    Messages.get();
                    ConsoleJob job = new ConsoleJob(Messages.FileViewer_Stop_File_Monitoring, null, "org.netxms.ui.eclipse.filemanager", null){

                        protected void runInternal(IProgressMonitor monitor) throws Exception {
                            session.cancelFileMonitoring(nodeId, file.getId());
                        }

                        protected String getErrorMessage() {
                            Messages.get();
                            return Messages.FileViewer_Cannot_Stop_File_Monitoring;
                        }
                    };
                    job.setUser(false);
                    job.setSystem(true);
                    job.start();
                }
                return false;
            }
        }
        AgentFileViewer view = (AgentFileViewer)window.getActivePage().showView(ID, secondaryId, 1);
        view.viewer.setLineStyler(lineStyler);
        view.followChanges = followChanges;
        view.viewer.showFile(file.getFile());
        if (followChanges) {
            view.viewer.startTracking(nodeId, file.getId(), file.getRemoteName());
        }
        return true;
    }
}

