/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class SNMP
extends PropertyPage {
    private AbstractNode node;
    private Combo snmpVersion;
    private LabeledText snmpPort;
    private Combo snmpAuth;
    private Combo snmpPriv;
    private ObjectSelector snmpProxy;
    private LabeledText snmpAuthName;
    private LabeledText snmpAuthPassword;
    private LabeledText snmpPrivPassword;

    protected Control createContents(Composite parent) {
        String string;
        this.node = (AbstractNode)this.getElement().getAdapter(AbstractNode.class);
        Composite dialogArea = new Composite(parent, 0);
        FormLayout dialogLayout = new FormLayout();
        dialogLayout.marginWidth = 0;
        dialogLayout.marginHeight = 0;
        dialogLayout.spacing = 5;
        dialogArea.setLayout((Layout)dialogLayout);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        Messages.get();
        this.snmpVersion = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)Messages.Communication_Version, (Object)fd);
        this.snmpVersion.add("1");
        this.snmpVersion.add("2c");
        this.snmpVersion.add("3");
        this.snmpVersion.select(this.snmpVersionToIndex(this.node.getSnmpVersion()));
        this.snmpVersion.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                SNMP.this.onSnmpVersionChange();
            }
        });
        this.snmpPort = new LabeledText(dialogArea, 0);
        Messages.get();
        this.snmpPort.setLabel(Messages.Communication_UDPPort);
        this.snmpPort.setText(Integer.toString(this.node.getSnmpPort()));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.snmpVersion.getParent(), 0, 1024);
        Messages.get();
        this.snmpAuth = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)Messages.Communication_Authentication, (Object)fd);
        Messages.get();
        this.snmpAuth.add(Messages.Communication_AuthNone);
        Messages.get();
        this.snmpAuth.add(Messages.Communication_AuthMD5);
        Messages.get();
        this.snmpAuth.add(Messages.Communication_AuthSHA1);
        this.snmpAuth.select(this.node.getSnmpAuthMethod());
        this.snmpAuth.setEnabled(this.node.getSnmpVersion() == 3);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.snmpAuth.getParent(), 0, 131072);
        fd.top = new FormAttachment((Control)this.snmpVersion.getParent(), 0, 1024);
        Messages.get();
        this.snmpPriv = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)Messages.Communication_Encryption, (Object)fd);
        Messages.get();
        this.snmpPriv.add(Messages.Communication_EncNone);
        Messages.get();
        this.snmpPriv.add(Messages.Communication_EncDES);
        Messages.get();
        this.snmpPriv.add(Messages.Communication_EncAES);
        this.snmpPriv.select(this.node.getSnmpPrivMethod());
        this.snmpPriv.setEnabled(this.node.getSnmpVersion() == 3);
        this.snmpProxy = new ObjectSelector(dialogArea, 0, true);
        Messages.get();
        this.snmpProxy.setLabel(Messages.Communication_Proxy);
        this.snmpProxy.setObjectId(this.node.getSnmpProxyId());
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.snmpAuth.getParent(), 0, 1024);
        fd.right = new FormAttachment((Control)this.snmpPriv.getParent(), 0, 131072);
        this.snmpProxy.setLayoutData((Object)fd);
        this.snmpAuthName = new LabeledText(dialogArea, 0);
        if (this.node.getSnmpVersion() == 3) {
            Messages.get();
            string = Messages.Communication_UserName;
        } else {
            Messages.get();
            string = Messages.Communication_Community;
        }
        this.snmpAuthName.setLabel(string);
        this.snmpAuthName.setText(this.node.getSnmpAuthName());
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.snmpProxy, 0, 131072);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.snmpAuthName.setLayoutData((Object)fd);
        this.snmpAuthPassword = new LabeledText(dialogArea, 0);
        Messages.get();
        this.snmpAuthPassword.setLabel(Messages.Communication_AuthPassword);
        this.snmpAuthPassword.setText(this.node.getSnmpAuthPassword());
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.snmpAuthName, 0, 16384);
        fd.top = new FormAttachment((Control)this.snmpAuth.getParent(), 0, 128);
        fd.right = new FormAttachment(100, 0);
        this.snmpAuthPassword.setLayoutData((Object)fd);
        this.snmpAuthPassword.getTextControl().setEnabled(this.node.getSnmpVersion() == 3);
        this.snmpPrivPassword = new LabeledText(dialogArea, 0);
        Messages.get();
        this.snmpPrivPassword.setLabel(Messages.Communication_EncPassword);
        this.snmpPrivPassword.setText(this.node.getSnmpPrivPassword());
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.snmpAuthName, 0, 16384);
        fd.top = new FormAttachment((Control)this.snmpProxy, 0, 128);
        fd.right = new FormAttachment(100, 0);
        this.snmpPrivPassword.setLayoutData((Object)fd);
        this.snmpPrivPassword.getTextControl().setEnabled(this.node.getSnmpVersion() == 3);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.snmpVersion.getParent(), 0, 131072);
        fd.right = new FormAttachment((Control)this.snmpAuthName, 0, 16384);
        fd.top = new FormAttachment(0, 0);
        this.snmpPort.setLayoutData((Object)fd);
        return dialogArea;
    }

    private int snmpVersionToIndex(int version) {
        switch (version) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return 0;
    }

    private int snmpIndexToVersion(int index) {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 3;
        int[] versions = nArray;
        return versions[index];
    }

    private void onSnmpVersionChange() {
        String string;
        boolean isV3;
        boolean bl = isV3 = this.snmpVersion.getSelectionIndex() == 2;
        if (isV3) {
            Messages.get();
            string = Messages.Communication_UserName;
        } else {
            Messages.get();
            string = Messages.Communication_Community;
        }
        this.snmpAuthName.setLabel(string);
        this.snmpAuth.setEnabled(isV3);
        this.snmpPriv.setEnabled(isV3);
        this.snmpAuthPassword.getTextControl().setEnabled(isV3);
        this.snmpPrivPassword.getTextControl().setEnabled(isV3);
    }

    protected boolean applyChanges(final boolean isApply) {
        final NXCObjectModificationData md = new NXCObjectModificationData(this.node.getObjectId());
        if (isApply) {
            this.setValid(false);
        }
        md.setSnmpVersion(this.snmpIndexToVersion(this.snmpVersion.getSelectionIndex()));
        try {
            md.setSnmpPort(Integer.parseInt(this.snmpPort.getText(), 10));
        }
        catch (NumberFormatException numberFormatException) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialog.openWarning((Shell)shell, (String)Messages.Communication_Warning, (String)Messages.Communication_WarningInvalidSNMPPort);
            if (isApply) {
                this.setValid(true);
            }
            return false;
        }
        md.setSnmpProxy(this.snmpProxy.getObjectId());
        md.setSnmpAuthMethod(this.snmpAuth.getSelectionIndex());
        md.setSnmpPrivMethod(this.snmpPriv.getSelectionIndex());
        md.setSnmpAuthName(this.snmpAuthName.getText());
        md.setSnmpAuthPassword(this.snmpAuthPassword.getText());
        md.setSnmpPrivPassword(this.snmpPrivPassword.getText());
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob(String.format("Updating SNMP settings for node %s", this.node.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                return String.format("Cannot update SNMP settings for node %s", SNMP.this.node.getObjectName());
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            SNMP.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.snmpVersion.select(0);
        this.snmpAuth.select(0);
        this.snmpPriv.select(0);
        this.snmpAuthName.setText("public");
        this.snmpAuthPassword.setText("");
        this.snmpPrivPassword.setText("");
        this.snmpProxy.setObjectId(0L);
        this.onSnmpVersionChange();
    }
}

