/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.objectview.widgets.ObjectStatusMap;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectStatusMapView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.objectview.views.ObjectStatusMapView";
    private long rootObjectId;
    private ObjectStatusMap map;
    private boolean initialGroupFlag = true;
    private boolean initialShowFilter = true;
    private Action actionRefresh;
    private Action actionGroupNodes;
    private Action actionShowFilter;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        NXCSession session = ConsoleSharedData.getSession();
        this.rootObjectId = Long.parseLong(site.getSecondaryId());
        AbstractObject object = session.findObjectById(this.rootObjectId);
        Messages.get();
        this.setPartName(String.format(Messages.ObjectStatusMapView_PartName, object != null ? object.getObjectName() : "[" + this.rootObjectId + "]"));
    }

    public void createPartControl(Composite parent) {
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.initialGroupFlag = settings.get("GroupObjects") != null ? settings.getBoolean("GroupObjects") : true;
        this.initialShowFilter = settings.get("ShowFilter") != null ? settings.getBoolean("ShowFilter") : true;
        this.map = new ObjectStatusMap((IViewPart)this, parent, 0, true);
        this.map.setGroupObjects(this.initialGroupFlag);
        this.map.setRootObject(this.rootObjectId);
        this.map.enableFilter(this.initialShowFilter);
        this.map.setFilterCloseAction(new Action(){

            public void run() {
                ObjectStatusMapView.this.actionShowFilter.setChecked(false);
                ObjectStatusMapView.this.map.enableFilter(false);
            }
        });
        this.map.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                settings.put("GroupObjects", ObjectStatusMapView.this.map.isGroupObjects());
                settings.put("ShowFilter", ObjectStatusMapView.this.map.isFilterEnabled());
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.getSite().setSelectionProvider((ISelectionProvider)this.map);
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                ObjectStatusMapView.this.map.refresh();
            }
        };
        Messages.get();
        this.actionGroupNodes = new Action(Messages.ObjectStatusMapView_ActionGroupNodes, 2){

            public void run() {
                ObjectStatusMapView.this.map.setGroupObjects(ObjectStatusMapView.this.actionGroupNodes.isChecked());
                ObjectStatusMapView.this.map.refresh();
            }
        };
        this.actionGroupNodes.setChecked(this.initialGroupFlag);
        Messages.get();
        this.actionShowFilter = new Action(Messages.ObjectStatusMapView_ActionShowFilter, 2){

            public void run() {
                ObjectStatusMapView.this.map.enableFilter(ObjectStatusMapView.this.actionShowFilter.isChecked());
            }
        };
        this.actionShowFilter.setChecked(this.initialShowFilter);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionGroupNodes);
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    public void setFocus() {
        this.map.setFocus();
    }
}

