/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectContextMenu;
import org.netxms.ui.eclipse.objectview.api.ObjectDetailsProvider;
import org.netxms.ui.eclipse.objectview.widgets.ObjectStatusWidget;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.FilterText;

public class ObjectStatusMap
extends Composite
implements ISelectionProvider {
    private IViewPart viewPart;
    private long rootObjectId;
    private NXCSession session;
    private FilterText filterTextControl;
    private ScrolledComposite scroller;
    private Composite dataArea;
    private List<Composite> sections = new ArrayList<Composite>();
    private Map<Long, ObjectStatusWidget> statusWidgets = new HashMap<Long, ObjectStatusWidget>();
    private ISelection selection = null;
    private Set<ISelectionChangedListener> selectionListeners = new HashSet<ISelectionChangedListener>();
    private MenuManager menuManager;
    private Font titleFont;
    private boolean groupObjects = true;
    private boolean filterEnabled = true;
    private int severityFilter = 255;
    private String textFilter = "";
    private SortedMap<Integer, ObjectDetailsProvider> detailsProviders = new TreeMap<Integer, ObjectDetailsProvider>();
    private Set<Runnable> refreshListeners = new HashSet<Runnable>();

    public ObjectStatusMap(IViewPart viewPart, Composite parent, int style, boolean allowFilterClose) {
        super(parent, style);
        this.initDetailsProviders();
        this.viewPart = viewPart;
        this.session = ConsoleSharedData.getSession();
        final SessionListener sessionListener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 4) {
                    ObjectStatusMap.this.onObjectChange((AbstractObject)n.getObject());
                } else if (n.getCode() == 99) {
                    ObjectStatusMap.this.onObjectDelete(n.getSubCode());
                }
            }
        };
        this.session.addListener(sessionListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ObjectStatusMap.this.session.removeListener(sessionListener);
            }
        });
        FormLayout formLayout = new FormLayout();
        this.setLayout((Layout)formLayout);
        this.setBackground(SharedColors.getColor((String)"ObjectTab.Background", (Display)this.getDisplay()));
        this.filterTextControl = new FilterText((Composite)this, 0, null, allowFilterClose);
        this.filterTextControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ObjectStatusMap.this.onFilterModify();
            }
        });
        this.filterTextControl.setCloseAction(new Action(){

            public void run() {
                ObjectStatusMap.this.enableFilter(false);
            }
        });
        this.scroller = new ScrolledComposite((Composite)this, 512);
        this.scroller.setBackground(this.getBackground());
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = ObjectStatusMap.this.getClientArea();
                ObjectStatusMap.this.scroller.setMinSize(ObjectStatusMap.this.dataArea.computeSize(r.width, -1));
            }
        });
        this.scroller.getVerticalBar().setIncrement(30);
        this.dataArea = new Composite((Composite)this.scroller, 0);
        this.scroller.setContent((Control)this.dataArea);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        this.dataArea.setLayout((Layout)layout);
        this.dataArea.setBackground(this.getBackground());
        if (Platform.getOS().equals("win32")) {
            this.titleFont = new Font((Device)parent.getDisplay(), "Verdana", 10, 1);
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ObjectStatusMap.this.titleFont.dispose();
                }
            });
        } else {
            this.titleFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.bannerfont");
        }
        this.menuManager = new MenuManager();
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ObjectStatusMap.this.fillContextMenu(manager);
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterTextControl);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.scroller.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterTextControl.setLayoutData((Object)fd);
        if (this.filterEnabled) {
            this.filterTextControl.setFocus();
        } else {
            this.enableFilter(false);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        ObjectContextMenu.fill((IMenuManager)manager, (IShellProvider)(this.viewPart != null ? this.viewPart.getSite() : null), (ISelectionProvider)this);
    }

    public void setRootObject(long objectId) {
        this.rootObjectId = objectId;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object s2;
        for (Object s2 : this.sections) {
            s2.dispose();
        }
        this.sections.clear();
        s2 = this.statusWidgets;
        synchronized (s2) {
            this.statusWidgets.clear();
        }
        if (this.groupObjects) {
            this.buildSection(this.rootObjectId, "");
        } else {
            this.buildFlatView();
        }
        this.dataArea.layout(true, true);
        Rectangle r = this.getClientArea();
        this.scroller.setMinSize(this.dataArea.computeSize(r.width, -1));
        for (Runnable l : this.refreshListeners) {
            l.run();
        }
    }

    private void buildFlatView() {
        AbstractObject root = this.session.findObjectById(this.rootObjectId);
        if (root == null || !(root instanceof Container) && !(root instanceof ServiceRoot) && !(root instanceof Cluster)) {
            return;
        }
        ArrayList objects = new ArrayList(root.getAllChilds(new int[]{2, 14}));
        if ((this.severityFilter & 0x3F) != 63 || !this.textFilter.isEmpty()) {
            Iterator it = objects.iterator();
            while (it.hasNext()) {
                AbstractObject o = (AbstractObject)it.next();
                if ((1 << o.getStatus().getValue() & this.severityFilter) == 0) {
                    it.remove();
                    continue;
                }
                if (this.textFilter.isEmpty()) continue;
                boolean match = false;
                for (String s : o.getStrings()) {
                    if (!s.toLowerCase().contains(this.textFilter)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                it.remove();
            }
        }
        Collections.sort(objects, new Comparator<AbstractObject>(){

            @Override
            public int compare(AbstractObject o1, AbstractObject o2) {
                return o1.getObjectName().compareToIgnoreCase(o2.getObjectName());
            }
        });
        Composite clientArea = new Composite(this.dataArea, 0);
        clientArea.setBackground(this.getBackground());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        clientArea.setLayoutData((Object)gd);
        RowLayout clayout = new RowLayout();
        clayout.marginBottom = 0;
        clayout.marginTop = 0;
        clayout.marginLeft = 0;
        clayout.marginRight = 0;
        clayout.type = 256;
        clayout.wrap = true;
        clayout.pack = false;
        clientArea.setLayout((Layout)clayout);
        this.sections.add(clientArea);
        for (AbstractObject o : objects) {
            if (!(o instanceof AbstractNode) && !(o instanceof Cluster)) continue;
            this.addObjectElement(clientArea, o);
        }
    }

    private void buildSection(long rootId, String namePrefix) {
        AbstractObject root = this.session.findObjectById(rootId);
        if (root == null || !(root instanceof Container) && !(root instanceof ServiceRoot) && !(root instanceof Cluster)) {
            return;
        }
        ArrayList<AbstractObject> objects = new ArrayList<AbstractObject>(Arrays.asList(root.getChildsAsArray()));
        Collections.sort(objects, new Comparator<AbstractObject>(){

            @Override
            public int compare(AbstractObject o1, AbstractObject o2) {
                return o1.getObjectName().compareToIgnoreCase(o2.getObjectName());
            }
        });
        Composite section = null;
        Composite clientArea = null;
        for (AbstractObject o : objects) {
            if (!(o instanceof AbstractNode) && !(o instanceof Cluster) || (1 << o.getStatus().getValue() & this.severityFilter) == 0) continue;
            if (!this.textFilter.isEmpty()) {
                boolean match = false;
                for (String s : o.getStrings()) {
                    if (!s.toLowerCase().contains(this.textFilter)) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
            }
            if (section == null) {
                section = new Composite(this.dataArea, 0);
                section.setBackground(this.getBackground());
                GridData gd = new GridData();
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalAlignment = 4;
                section.setLayoutData((Object)gd);
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                section.setLayout((Layout)layout);
                Label title = new Label(section, 0);
                title.setBackground(this.getBackground());
                title.setFont(this.titleFont);
                title.setText(String.valueOf(namePrefix) + root.getObjectName());
                clientArea = new Composite(section, 0);
                clientArea.setBackground(this.getBackground());
                gd = new GridData();
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalAlignment = 4;
                clientArea.setLayoutData((Object)gd);
                RowLayout clayout = new RowLayout();
                clayout.marginBottom = 0;
                clayout.marginTop = 0;
                clayout.marginLeft = 0;
                clayout.marginRight = 0;
                clayout.type = 256;
                clayout.wrap = true;
                clayout.pack = false;
                clientArea.setLayout((Layout)clayout);
                this.sections.add(section);
            }
            this.addObjectElement(clientArea, o);
        }
        for (AbstractObject o : objects) {
            if (!(o instanceof Container) && !(o instanceof ServiceRoot) && !(o instanceof Cluster)) continue;
            this.buildSection(o.getObjectId(), String.valueOf(namePrefix) + root.getObjectName() + " / ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addObjectElement(Composite parent, final AbstractObject object) {
        ObjectStatusWidget w = new ObjectStatusWidget(parent, object);
        w.setBackground(this.getBackground());
        w.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                ObjectStatusMap.this.setSelection((ISelection)new StructuredSelection((Object)object));
                if (e.button == 1) {
                    ObjectStatusMap.this.callDetailsProvider(object);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        Menu menu = this.menuManager.createContextMenu((Control)w);
        w.setMenu(menu);
        if (this.viewPart != null) {
            this.viewPart.getSite().registerContextMenu(this.menuManager, (ISelectionProvider)this);
        }
        Map<Long, ObjectStatusWidget> map = this.statusWidgets;
        synchronized (map) {
            this.statusWidgets.put(object.getObjectId(), w);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener l : this.selectionListeners) {
            l.selectionChanged(event);
        }
    }

    public boolean isGroupObjects() {
        return this.groupObjects;
    }

    public void setGroupObjects(boolean groupObjects) {
        this.groupObjects = groupObjects;
    }

    private void initDetailsProviders() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.objectview.objectDetailsProvider");
        int i = 0;
        while (i < elements.length) {
            try {
                int priority;
                ObjectDetailsProvider provider = (ObjectDetailsProvider)elements[i].createExecutableExtension("class");
                try {
                    priority = Integer.parseInt(elements[i].getAttribute("priority"));
                }
                catch (NumberFormatException numberFormatException) {
                    priority = 65535;
                }
                this.detailsProviders.put(priority, provider);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private void callDetailsProvider(AbstractObject object) {
        for (ObjectDetailsProvider p : this.detailsProviders.values()) {
            if (!p.canProvideDetails(object)) continue;
            p.provideDetails(object, this.viewPart);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onObjectChange(final AbstractObject object) {
        if (!(object instanceof AbstractNode || object instanceof Container || object instanceof Cluster || object instanceof ServiceRoot)) {
            return;
        }
        Map<Long, ObjectStatusWidget> map = this.statusWidgets;
        synchronized (map) {
            final ObjectStatusWidget w = this.statusWidgets.get(object.getObjectId());
            if (w != null) {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!w.isDisposed()) {
                            w.updateObject(object);
                        }
                    }
                });
            } else if (object.getObjectId() == this.rootObjectId || object.isChildOf(this.rootObjectId)) {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!ObjectStatusMap.this.isDisposed()) {
                            ObjectStatusMap.this.refresh();
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onObjectDelete(long objectId) {
        Map<Long, ObjectStatusWidget> map = this.statusWidgets;
        synchronized (map) {
            if (this.statusWidgets.containsKey(objectId)) {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!ObjectStatusMap.this.isDisposed()) {
                            ObjectStatusMap.this.refresh();
                        }
                    }
                });
            }
        }
    }

    public int getSeverityFilter() {
        return this.severityFilter;
    }

    public void setSeverityFilter(int severityFilter) {
        this.severityFilter = severityFilter;
    }

    public void addRefreshListener(Runnable listener) {
        this.refreshListeners.add(listener);
    }

    public void removeRefreshListener(Runnable listener) {
        this.refreshListeners.remove(listener);
    }

    public void enableFilter(boolean enable) {
        this.filterEnabled = enable;
        this.filterTextControl.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.scroller.getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterTextControl) : new FormAttachment(0, 0);
        this.layout();
        if (enable) {
            this.filterTextControl.setFocus();
        } else {
            this.setFilterText("");
        }
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public void setFilterCloseAction(Action action) {
        this.filterTextControl.setCloseAction(action);
    }

    public void setFilterText(String text) {
        this.filterTextControl.setText(text);
        this.onFilterModify();
    }

    public String getFilterText() {
        return this.filterTextControl.getText();
    }

    private void onFilterModify() {
        String text = this.filterTextControl.getText().trim().toLowerCase();
        if (!this.textFilter.equals(text)) {
            this.textFilter = text;
            this.refresh();
        }
    }
}

