/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.policymanager.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AgentPolicyConfig;
import org.netxms.ui.eclipse.agentmanager.dialogs.SaveStoredConfigDialog;
import org.netxms.ui.eclipse.agentmanager.widgets.AgentConfigEditor;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.NXFindAndReplaceAction;

public class ConfigPolicyEditor
extends ViewPart
implements ISaveablePart2 {
    public static final String ID = "org.netxms.ui.eclipse.policymanager.views.ConfigPolicyEditor";
    private AgentConfigEditor editor;
    private boolean modified = false;
    private boolean dirty = false;
    private AgentPolicyConfig configPolicy;
    private Action actionSave;
    private FindReplaceAction actionFindReplace;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.editor = new AgentConfigEditor(parent, 0, 768);
        this.editor.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ConfigPolicyEditor.this.dirty) {
                    ConfigPolicyEditor.this.modified = true;
                    ConfigPolicyEditor.this.dirty = true;
                    ConfigPolicyEditor.this.firePropertyChange(257);
                    ConfigPolicyEditor.this.actionSave.setEnabled(true);
                    ConfigPolicyEditor.this.actionFindReplace.update();
                }
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.actionSave.setEnabled(false);
    }

    public void setFocus() {
        this.editor.setFocus();
    }

    public void setPolicy(AbstractObject policy) {
        this.configPolicy = (AgentPolicyConfig)policy;
        this.editor.setText(this.configPolicy.getFileContent());
        this.setPartName("Edit Policy \"" + this.configPolicy.getObjectName() + "\"");
    }

    private void createActions() {
        this.actionFindReplace = NXFindAndReplaceAction.getFindReplaceAction((ViewPart)this);
        this.actionSave = new Action(){

            public void run() {
                ConfigPolicyEditor.this.doSave(null);
                ConfigPolicyEditor.this.actionSave.setEnabled(false);
                ConfigPolicyEditor.this.dirty = false;
            }
        };
        this.actionSave.setText("Save");
        this.actionSave.setImageDescriptor(SharedIcons.SAVE);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionFindReplace);
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            NXCObjectModificationData md = new NXCObjectModificationData(this.configPolicy.getObjectId());
            md.setConfigFileContent(this.editor.getText());
            ConsoleSharedData.getSession().modifyObject(md);
        }
        catch (Exception e) {
            MessageDialogHelper.openError((Shell)this.getViewSite().getShell(), (String)"Error updating configuration agent policy object", (String)("Error: " + e.getMessage()));
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.dirty || this.modified;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }

    public int promptToSaveOnClose() {
        SaveStoredConfigDialog dlg = new SaveStoredConfigDialog(this.getSite().getShell());
        int rc = dlg.open();
        if (rc == 100) {
            this.modified = false;
            return 0;
        }
        if (rc == 1) {
            return 2;
        }
        return 1;
    }
}

