/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum RackOrientation {
    FILL(0),
    FRONT(1),
    REAR(2);

    private int value;
    private static Map<Integer, RackOrientation> lookupTable;

    private RackOrientation(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static RackOrientation getByValue(int value) {
        RackOrientation element = lookupTable.get(value);
        if (element == null) {
            Logger.warning(RackOrientation.class.getName(), "Unknown element " + value);
            return FILL;
        }
        return element;
    }

    static {
        lookupTable = new HashMap<Integer, RackOrientation>();
        for (RackOrientation element : RackOrientation.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

