/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.IllegalFormatException;

public class DataFormatter {
    private String formatString;
    private boolean useBinaryMultipliers;
    private int dataType;
    private static final long[] DECIMAL_MULTIPLIERS = new long[]{1L, 1000L, 1000000L, 1000000000L, 1000000000000L, 1000000000000000L};
    private static final long[] BINARY_MULTIPLIERS = new long[]{1024L, 0x100000L, 0x40000000L, 0x10000000000L, 0x1000000000000000L};
    private static final String[] SUFFIX = new String[]{"", " k", " M", " G", " T", " P"};
    private static final String[] FORMATS = new String[]{"", ".0", ".00", ".000", ".0000", ".00000", ".000000"};

    public DataFormatter(String formatString, int dataType, boolean useBinaryMultipliers) {
        this.formatString = formatString;
        this.dataType = dataType;
        this.useBinaryMultipliers = useBinaryMultipliers;
    }

    public DataFormatter(String formatString, int dataType) {
        this(formatString, dataType, false);
    }

    public DataFormatter(int precision, String formatString) {
        this(formatString, 4, false);
    }

    public String format(String value) {
        StringBuilder sb = new StringBuilder();
        char[] format = this.formatString.toCharArray();
        for (int i = 0; i < format.length; ++i) {
            if (format[i] == '%') {
                int j;
                if (format[++i] == '%') {
                    sb.append('%');
                    continue;
                }
                for (j = i; j < format.length && !Character.isLetter(format[j]); ++j) {
                }
                boolean useMultipliers = false;
                if (format[i] == '*') {
                    ++i;
                    useMultipliers = true;
                }
                String f = "%" + new String(Arrays.copyOfRange(format, i, j + 1));
                i = j;
                try {
                    Value v = this.getValueForFormat(value, useMultipliers, format[j] == 's');
                    sb.append(String.format(f, v.value));
                    sb.append(v.suffix);
                }
                catch (IllegalFormatException e) {
                    sb.append("<INVALID FORMAT> (");
                    sb.append(f);
                    sb.append(")");
                }
                continue;
            }
            sb.append(format[i]);
        }
        return sb.toString();
    }

    private Value getValueForFormat(String value, boolean useMultipliers, boolean stringOutput) {
        Value v = new Value();
        if (this.dataType != 0 && this.dataType != 1 && this.dataType != 2 && this.dataType != 3 && this.dataType != 5) {
            v.value = value;
            return v;
        }
        try {
            if (useMultipliers) {
                int i;
                long[] multipliers = this.useBinaryMultipliers ? BINARY_MULTIPLIERS : DECIMAL_MULTIPLIERS;
                Double d = Double.parseDouble(value);
                for (i = multipliers.length - 1; i >= 0 && !(d >= (double)multipliers[i]) && !(d <= (double)(-multipliers[i])); --i) {
                }
                if (i >= 0) {
                    if (stringOutput) {
                        NumberFormat nf = NumberFormat.getNumberInstance();
                        nf.setMaximumFractionDigits(2);
                        v.value = nf.format(d / (double)multipliers[i]);
                    } else {
                        v.value = d / (double)multipliers[i];
                    }
                    v.suffix = SUFFIX[i];
                } else {
                    v.value = stringOutput ? value : (this.dataType == 5 ? (Number)Double.parseDouble(value) : (Number)Long.parseLong(value));
                }
            } else {
                v.value = stringOutput ? value : (this.dataType == 5 ? (Number)Double.parseDouble(value) : (Number)Long.parseLong(value));
            }
        }
        catch (NumberFormatException e) {
            v.value = value;
        }
        return v;
    }

    private static int calculatePrecision(double number) {
        int i = 0;
        if (number == 0.0 || number >= 1.0) {
            return i;
        }
        for (i = 1; i < 1000; ++i) {
            double d;
            number *= 10.0;
            if (d >= 1.0) break;
        }
        return i;
    }

    public static String roundDecimalValue(double value, double step, int maxPrecision) {
        int i;
        if (value == 0.0) {
            return "0";
        }
        double absValue = Math.abs(value);
        long[] multipliers = DECIMAL_MULTIPLIERS;
        for (i = multipliers.length - 1; i >= 0 && !(absValue >= (double)multipliers[i]); --i) {
        }
        int precision = step < 1.0 || i < 0 ? (DataFormatter.calculatePrecision(step) > maxPrecision ? maxPrecision : DataFormatter.calculatePrecision(step)) : (DataFormatter.calculatePrecision(step / (double)multipliers[i]) > maxPrecision ? maxPrecision : DataFormatter.calculatePrecision(step / (double)multipliers[i]));
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(precision);
        return df.format(i < 0 ? value : value / (double)multipliers[i]) + (i < 0 ? "" : SUFFIX[i]);
    }

    private class Value {
        Object value;
        String suffix = "";

        private Value() {
        }
    }
}

