/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class XlsxRunHelper
extends BaseHelper {
    public static final String COLOR_NONE = "none";
    private String exporterKey;

    public XlsxRunHelper(JasperReportsContext jasperReportsContext, Writer writer, String exporterKey) {
        super(jasperReportsContext, writer);
        this.exporterKey = exporterKey;
    }

    public void export(JRStyle style, Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale, String invalidCharReplacement, boolean isStyledText) {
        if (text != null) {
            this.write("<r>\n");
            if (isStyledText) {
                this.exportProps(this.getAttributes(style), attributes, locale);
            }
            this.write("<t xml:space=\"preserve\">");
            this.write(JRStringUtil.xmlEncode(text, invalidCharReplacement));
            this.write("</t></r>\n");
        }
    }

    public void exportProps(Map<AttributedCharacterIterator.Attribute, Object> parentAttrs, Map<AttributedCharacterIterator.Attribute, Object> attrs, Locale locale) {
        Object value;
        boolean isOpen = false;
        Object object = value = attrs.get(TextAttribute.FAMILY) == null ? parentAttrs.get(TextAttribute.FAMILY) : attrs.get(TextAttribute.FAMILY);
        if (value != null) {
            String fontFamilyAttr = (String)value;
            String fontFamily = this.fontUtil.getExportFontFamily(fontFamilyAttr, locale, this.exporterKey);
            this.write("       <rPr>\n");
            this.write("        <rFont val=\"" + fontFamily + "\"/>\n");
            isOpen = true;
        }
        if (isOpen) {
            Object object2 = value = attrs.get(TextAttribute.FOREGROUND) == null ? parentAttrs.get(TextAttribute.FOREGROUND) : attrs.get(TextAttribute.FOREGROUND);
            if (value != null) {
                this.write("        <color rgb=\"" + JRColorUtil.getColorHexa((Color)value) + "\" />\n");
            }
            Object object3 = value = attrs.get(TextAttribute.SIZE) == null ? parentAttrs.get(TextAttribute.SIZE) : attrs.get(TextAttribute.SIZE);
            if (value != null) {
                this.write("        <sz val=\"" + value + "\" />\n");
            }
            Object object4 = value = attrs.get(TextAttribute.WEIGHT) == null ? parentAttrs.get(TextAttribute.WEIGHT) : attrs.get(TextAttribute.WEIGHT);
            if (value != null) {
                this.write("        <b val=\"" + value.equals(TextAttribute.WEIGHT_BOLD) + "\"/>\n");
            }
            Object object5 = value = attrs.get(TextAttribute.POSTURE) == null ? parentAttrs.get(TextAttribute.POSTURE) : attrs.get(TextAttribute.POSTURE);
            if (value != null) {
                this.write("        <i val=\"" + value.equals(TextAttribute.POSTURE_OBLIQUE) + "\"/>\n");
            }
            Object object6 = value = attrs.get(TextAttribute.UNDERLINE) == null ? parentAttrs.get(TextAttribute.UNDERLINE) : attrs.get(TextAttribute.UNDERLINE);
            if (value != null) {
                this.write("        <u val=\"" + (value == null ? COLOR_NONE : "single") + "\"/>\n");
            }
            Object object7 = value = attrs.get(TextAttribute.STRIKETHROUGH) == null ? parentAttrs.get(TextAttribute.STRIKETHROUGH) : attrs.get(TextAttribute.STRIKETHROUGH);
            if (value != null) {
                this.write("        <strike val=\"" + (value != null) + "\"/>\n");
            }
        }
        if (TextAttribute.SUPERSCRIPT_SUPER.equals(value = attrs.get(TextAttribute.SUPERSCRIPT))) {
            if (!isOpen) {
                this.write("       <rPr>\n");
                isOpen = true;
            }
            this.write("        <vertAlign val=\"superscript\" />\n");
        } else if (TextAttribute.SUPERSCRIPT_SUB.equals(value)) {
            if (!isOpen) {
                this.write("       <rPr>\n");
                isOpen = true;
            }
            this.write("        <vertAlign val=\"subscript\" />\n");
        }
        if (isOpen) {
            this.write("       </rPr>\n");
        }
    }

    private Map<AttributedCharacterIterator.Attribute, Object> getAttributes(JRStyle style) {
        JRBasePrintText text = new JRBasePrintText(null);
        text.setStyle(style);
        HashMap<AttributedCharacterIterator.Attribute, Object> styledTextAttributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        this.fontUtil.getAttributesWithoutAwtFont(styledTextAttributes, text);
        styledTextAttributes.put(TextAttribute.FOREGROUND, text.getForecolor());
        if (text.getModeValue() == ModeEnum.OPAQUE) {
            styledTextAttributes.put(TextAttribute.BACKGROUND, text.getBackcolor());
        }
        return styledTextAttributes;
    }
}

