/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AgentPolicy;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class AutoDeploy
extends PropertyPage {
    private AgentPolicy object;
    private Button checkboxEnableDeploy;
    private Button checkboxEnableUninstall;
    private ScriptEditor filterSource;
    private int initialFlags;
    private String initialAutoDeployFilter;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (AgentPolicy)this.getElement().getAdapter(AgentPolicy.class);
        if (this.object == null) {
            return dialogArea;
        }
        this.initialFlags = this.object.getFlags();
        this.initialAutoDeployFilter = this.object.getAutoDeployFilter();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkboxEnableDeploy = new Button(dialogArea, 32);
        this.checkboxEnableDeploy.setText("Deploy this policy automatically to nodes selected by filter");
        this.checkboxEnableDeploy.setSelection(this.object.isAutoDeployEnabled());
        this.checkboxEnableDeploy.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (AutoDeploy.this.checkboxEnableDeploy.getSelection()) {
                    AutoDeploy.this.filterSource.setEnabled(true);
                    AutoDeploy.this.filterSource.setFocus();
                    AutoDeploy.this.checkboxEnableUninstall.setEnabled(true);
                } else {
                    AutoDeploy.this.filterSource.setEnabled(false);
                    AutoDeploy.this.checkboxEnableUninstall.setEnabled(false);
                }
            }
        });
        this.checkboxEnableUninstall = new Button(dialogArea, 32);
        this.checkboxEnableUninstall.setText("Uninstall this policy automatically when node no longer passes through filter");
        this.checkboxEnableUninstall.setSelection(this.object.isAutoUninstallEnabled());
        this.checkboxEnableUninstall.setEnabled(this.object.isAutoDeployEnabled());
        Label label = new Label(dialogArea, 0);
        Messages.get();
        label.setText(Messages.AutoBind_Script);
        GridData gd = new GridData();
        gd.verticalIndent = 5;
        label.setLayoutData((Object)gd);
        this.filterSource = new ScriptEditor(dialogArea, 2048, 768, true, "Variables:\r\n\t$node\tnode being tested (null if object is not a node).\r\n\t$object\tobject being tested.\r\n\r\nReturn value: true to deploy this policy onto node, false to uninstall, null to make no changes.");
        this.filterSource.setText(this.object.getAutoDeployFilter());
        this.filterSource.setEnabled(this.object.isAutoDeployEnabled());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.filterSource.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        int flags = this.object.getFlags();
        flags = this.checkboxEnableDeploy.getSelection() ? (flags |= 1) : (flags &= 0xFFFFFFFE);
        flags = this.checkboxEnableUninstall.getSelection() ? (flags |= 2) : (flags &= 0xFFFFFFFD);
        if (flags == this.initialFlags && this.initialAutoDeployFilter.equals(this.filterSource.getText())) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setObjectFlags(flags);
        md.setAutoBindFilter(this.filterSource.getText());
        new ConsoleJob("Updating autodeploy configuration", null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
                AutoDeploy.this.initialFlags = md.getObjectFlags();
                AutoDeploy.this.initialAutoDeployFilter = md.getAutoBindFilter();
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            AutoDeploy.this.setValid(true);
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return "Cannot update autodeploy configuration";
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

